/*
 * Decompiled with CFR 0.152.
 */
package de.imdacro.economySystem.commands;

import de.imdacro.economySystem.EconomySystem;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class EconomyAdminCommand
implements CommandExecutor {
    private final EconomySystem plugin;

    public EconomyAdminCommand(EconomySystem plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s2, @NotNull String[] args) {
        double amount;
        if (args.length < 2) {
            commandSender.sendMessage(this.plugin.getMessages().get("usage", "%usage%", "/economyadmin <set|add|remove|balance> <player> [amount]"));
            return true;
        }
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(args[1]);
        if (!player.hasPlayedBefore() && !player.isOnline()) {
            commandSender.sendMessage(this.plugin.getMessages().get("player-not-found", new Object[0]));
            return true;
        }
        if (args[0].equalsIgnoreCase("balance")) {
            String playerUuid = player.getUniqueId().toString();
            if (!this.plugin.getDatabaseManager().accountExists(playerUuid)) {
                this.plugin.getDatabaseManager().createAccount(playerUuid);
            }
            double balance = this.plugin.getDatabaseManager().getBalance(playerUuid);
            commandSender.sendMessage(this.plugin.getMessages().get("balance-message-other", "%player%", player.getName(), "%balance%", String.valueOf(balance)));
            return true;
        }
        if (args.length < 3) {
            commandSender.sendMessage(this.plugin.getMessages().get("usage", "%usage%", "/economyadmin <set|add|remove> <player> <amount>"));
            return true;
        }
        try {
            amount = Double.parseDouble(args[2]);
        }
        catch (NumberFormatException e) {
            commandSender.sendMessage(this.plugin.getMessages().get("usage", "%usage%", "/economyadmin <set|add|remove> <player> <amount>"));
            return true;
        }
        if (amount <= 0.0) {
            commandSender.sendMessage(this.plugin.getMessages().get("usage", "%usage%", "/economyadmin <set|add|remove> <player> <amount>"));
            return true;
        }
        String playerUuid = player.getUniqueId().toString();
        if (!this.plugin.getDatabaseManager().accountExists(playerUuid)) {
            this.plugin.getDatabaseManager().createAccount(playerUuid);
        }
        switch (args[0]) {
            case "set": {
                this.plugin.getDatabaseManager().setBalance(playerUuid, amount);
                commandSender.sendMessage(this.plugin.getMessages().get("set-balance-success", "%player%", player.getName(), "%amount%", String.valueOf(amount)));
                break;
            }
            case "add": {
                this.plugin.getDatabaseManager().addBalance(playerUuid, amount);
                commandSender.sendMessage(this.plugin.getMessages().get("add-balance-success", "%player%", player.getName(), "%amount%", String.valueOf(amount)));
                break;
            }
            case "remove": {
                this.plugin.getDatabaseManager().removeBalance(playerUuid, amount);
                commandSender.sendMessage(this.plugin.getMessages().get("remove-balance-success", "%player%", player.getName(), "%amount%", String.valueOf(amount)));
                break;
            }
            default: {
                commandSender.sendMessage(this.plugin.getMessages().get("usage", "%usage%", "/economyadmin <set|add|remove> <player> <amount>"));
            }
        }
        return true;
    }
}

