/*
 * Decompiled with CFR 0.152.
 */
package de.imdacro.economySystem.commands;

import de.imdacro.economySystem.EconomySystem;
import de.imdacro.economySystem.database.DatabaseManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PayCommand
implements CommandExecutor {
    private final EconomySystem plugin;

    public PayCommand(EconomySystem plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s2, @NotNull String[] strings) {
        double playerBalance;
        double amount;
        if (strings.length < 2) {
            commandSender.sendMessage(this.plugin.getMessages().get("usage", "%usage%", "/pay <player> <amount>"));
            return true;
        }
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.plugin.getMessages().get("player-not-player", new Object[0]));
            return true;
        }
        Player player = (Player)commandSender;
        try {
            amount = Double.parseDouble(strings[1]);
        }
        catch (NumberFormatException e) {
            commandSender.sendMessage(this.plugin.getMessages().get("usage", "%usage%", "/pay <player> <amount>"));
            return true;
        }
        if (amount <= 0.0) {
            commandSender.sendMessage(this.plugin.getMessages().get("usage", "%usage%", "/pay <player> <amount>"));
            return true;
        }
        Player target = Bukkit.getPlayer((String)strings[0]);
        if (target == null) {
            commandSender.sendMessage(this.plugin.getMessages().get("player-not-found", new Object[0]));
            return true;
        }
        if (target.equals((Object)player)) {
            commandSender.sendMessage(this.plugin.getMessages().get("pay-self", new Object[0]));
            return true;
        }
        DatabaseManager databaseManager = this.plugin.getDatabaseManager();
        String playerUuid = player.getUniqueId().toString();
        String targetUuid = target.getUniqueId().toString();
        if (!databaseManager.accountExists(playerUuid)) {
            databaseManager.createAccount(playerUuid);
        }
        if (!databaseManager.accountExists(targetUuid)) {
            databaseManager.createAccount(targetUuid);
        }
        if ((playerBalance = databaseManager.getBalance(playerUuid)) < amount) {
            commandSender.sendMessage(this.plugin.getMessages().get("not-enough-money", new Object[0]));
            return true;
        }
        databaseManager.removeBalance(playerUuid, amount);
        databaseManager.addBalance(targetUuid, amount);
        databaseManager.createTransaction(playerUuid, targetUuid, amount);
        player.sendMessage(this.plugin.getMessages().get("pay-success-sender", "%player%", target.getName(), "%amount%", String.valueOf(amount)));
        target.sendMessage(this.plugin.getMessages().get("pay-success-receiver", "%player%", player.getName(), "%amount%", String.valueOf(amount)));
        return true;
    }
}

