/*
 * Decompiled with CFR 0.152.
 */
package de.imdacro.economySystem.database;

import de.imdacro.economySystem.EconomySystem;
import de.imdacro.economySystem.database.DatabaseManager;
import de.imdacro.economySystem.events.BalanceChangeEvent;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class LiteSQLManager
implements DatabaseManager {
    private final EconomySystem plugin;
    private Connection connection;
    private final File databaseFile;

    public LiteSQLManager(EconomySystem plugin) {
        this.plugin = plugin;
        String fileName = plugin.getConfig().getString("database.litesql.file", "economy.db");
        this.databaseFile = new File(plugin.getDataFolder(), fileName);
    }

    @Override
    public void connect() {
        try {
            if (!this.databaseFile.exists()) {
                if (this.databaseFile.getParentFile().mkdirs()) {
                    this.plugin.getLogger().info("Created directories for LiteSQL database.");
                }
                if (this.databaseFile.createNewFile()) {
                    this.plugin.getLogger().info("LiteSQL database file created: " + this.databaseFile.getAbsolutePath());
                } else {
                    this.plugin.getLogger().warning("Failed to create LiteSQL database file.");
                }
            }
            String url = "jdbc:sqlite:" + this.databaseFile.getAbsolutePath();
            this.connection = DriverManager.getConnection(url);
            this.plugin.getLogger().info("Connected to LiteSQL database at " + this.databaseFile.getName());
            this.createTables();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to create LiteSQL database file: " + e.getMessage());
            e.printStackTrace();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error connecting to LiteSQL database: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void createTables() {
        String createEconomyTable = "CREATE TABLE IF NOT EXISTS economy (uuid TEXT PRIMARY KEY, balance DOUBLE DEFAULT 0, created_at TEXT DEFAULT CURRENT_TIMESTAMP);";
        String createTransactionsTable = "CREATE TABLE IF NOT EXISTS economy_transactions (uuid_from TEXT, uuid_to TEXT, amount DOUBLE, created_at TEXT DEFAULT CURRENT_TIMESTAMP);";
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate(createEconomyTable);
            stmt.executeUpdate(createTransactionsTable);
            this.plugin.getLogger().info("Tables created or already exist.");
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.plugin.getLogger().severe("Error creating tables in LiteSQL!");
        }
    }

    @Override
    public void createAccount(String uuid) {
        double startBalance = this.plugin.getConfig().getDouble("economy.start-balance");
        try (PreparedStatement ps = this.connection.prepareStatement("INSERT INTO economy (uuid, balance) VALUES (?, ?)");){
            ps.setString(1, uuid);
            ps.setDouble(2, startBalance);
            ps.executeUpdate();
            this.plugin.getLogger().info("Account created for " + uuid + " with balance " + startBalance);
            this.createTransaction("SERVER", uuid, startBalance);
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.plugin.getLogger().severe("Error creating account for " + uuid);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean accountExists(String uuid) {
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT 1 FROM economy WHERE uuid = ? LIMIT 1");){
            boolean bl;
            block14: {
                ps.setString(1, uuid);
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public double getBalance(String uuid) {
        double balance = 0.0;
        try {
            PreparedStatement statement = this.connection.prepareStatement("SELECT balance FROM economy WHERE uuid = ?");
            statement.setString(1, uuid);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                balance = resultSet.getDouble("balance");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.plugin.getLogger().severe("Error fetching balance for UUID: " + uuid);
        }
        return balance;
    }

    @Override
    public void setBalance(String uuid, double balance) {
        if (balance < 0.0) {
            balance = 0.0;
        }
        try {
            PreparedStatement statement = this.connection.prepareStatement("UPDATE economy SET balance = ? WHERE uuid = ?");
            statement.setDouble(1, balance);
            statement.setString(2, uuid);
            statement.executeUpdate();
            BalanceChangeEvent balanceChangeEvent = new BalanceChangeEvent(Bukkit.getPlayer((UUID)UUID.fromString(uuid)), balance, !Bukkit.isPrimaryThread());
            Bukkit.getPluginManager().callEvent((Event)balanceChangeEvent);
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.plugin.getLogger().severe("Error setting balance for UUID: " + uuid);
        }
    }

    @Override
    public void addBalance(String uuid, double amount) {
        this.setBalance(uuid, this.getBalance(uuid) + amount);
    }

    @Override
    public void removeBalance(String uuid, double amount) {
        double currentBalance = this.getBalance(uuid);
        if (currentBalance - amount < 0.0) {
            amount = currentBalance;
        }
        this.setBalance(uuid, currentBalance - amount);
    }

    @Override
    public void createTransaction(String uuidFrom, String uuidTo, double amount) {
        try (PreparedStatement ps = this.connection.prepareStatement("INSERT INTO economy_transactions (uuid_from, uuid_to, amount) VALUES (?, ?, ?)");){
            ps.setString(1, uuidFrom);
            ps.setString(2, uuidTo);
            ps.setDouble(3, amount);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.plugin.getLogger().severe("Error creating transaction for " + uuidFrom + " to " + uuidTo);
        }
    }

    @Override
    public HashMap<String, Double> getTopBalances(int limit) {
        HashMap<String, Double> topBalances = new HashMap<String, Double>();
        try (Statement stmt = this.connection.createStatement();){
            ResultSet resultSet = stmt.executeQuery("SELECT uuid, balance FROM economy ORDER BY balance DESC LIMIT " + limit * 2);
            while (resultSet.next()) {
                if (this.plugin.getServer().getOfflinePlayer(UUID.fromString(resultSet.getString("uuid"))) != null && this.plugin.getServer().getOfflinePlayer(UUID.fromString(resultSet.getString("uuid"))).getPlayer().hasPermission("economysystem.toplist.ignore")) continue;
                if (topBalances.size() >= limit) {
                    break;
                }
                topBalances.put(resultSet.getString("uuid"), resultSet.getDouble("balance"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.plugin.getLogger().severe("Error fetching top balances.");
        }
        return topBalances;
    }

    @Override
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.plugin.getLogger().info("LiteSQL connection closed.");
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error closing LiteSQL connection: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

