/*
 * Decompiled with CFR 0.152.
 */
package de.imdacro.economySystem.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class Messages {
    private final JsonObject messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private String prefix = "";

    public Messages(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            this.messages = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (this.messages.has("prefix")) {
                this.prefix = this.messages.get("prefix").getAsString();
            }
        }
    }

    public Component get(String key, Object ... placeholders) {
        if (!this.messages.has(key)) {
            return Component.text((String)("Message not found: " + key));
        }
        String message = this.messages.get(key).getAsString();
        message = this.applyPlaceholders(message, placeholders);
        if (key.equals("prefix") || message.startsWith("<green>[EconomySystem]</green>")) {
            return this.miniMessage.deserialize((Object)message);
        }
        return this.miniMessage.deserialize((Object)(this.prefix + " " + message));
    }

    private String applyPlaceholders(String message, Object ... placeholders) {
        if (placeholders.length % 2 != 0) {
            throw new IllegalArgumentException("Placeholders must be in key-value pairs!");
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            String placeholder = placeholders[i].toString();
            String value = placeholders[i + 1].toString();
            message = message.replace(placeholder, value);
        }
        return message;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

