/*
 * Decompiled with CFR 0.152.
 */
package de.imdacro.economySystem.vault;

import de.imdacro.economySystem.EconomySystem;
import java.util.List;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;

public class EconomyProvider
extends AbstractEconomy {
    private final EconomySystem plugin;

    public EconomyProvider(EconomySystem plugin) {
        this.plugin = plugin;
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return this.plugin.getConfig().getString("economy.currency-name");
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return 0;
    }

    public String format(double amount) {
        return this.plugin.formatBalance(amount);
    }

    public String currencyNamePlural() {
        return this.plugin.getConfig().getString("economy.currency-name");
    }

    public String currencyNameSingular() {
        return this.plugin.getConfig().getString("economy.currency-name");
    }

    public boolean hasAccount(String playerName) {
        return this.plugin.getDatabaseManager().accountExists(Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString());
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.plugin.getDatabaseManager().accountExists(Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString());
    }

    public double getBalance(String playerName) {
        return this.plugin.getDatabaseManager().getBalance(Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString());
    }

    public double getBalance(String playerName, String world) {
        return this.plugin.getDatabaseManager().getBalance(Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString());
    }

    public boolean has(String playerName, double amount) {
        return this.plugin.getDatabaseManager().getBalance(Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString()) >= amount;
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.plugin.getDatabaseManager().getBalance(Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString()) >= amount;
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        this.plugin.getDatabaseManager().removeBalance(Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString(), amount);
        this.plugin.getDatabaseManager().createTransaction(Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString(), "VAULT", amount);
        return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.SUCCESS, "Error withdrawing money");
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        this.plugin.getDatabaseManager().removeBalance(Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString(), amount);
        this.plugin.getDatabaseManager().createTransaction(Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString(), "VAULT", amount);
        return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.SUCCESS, "Error withdrawing money");
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        this.plugin.getDatabaseManager().addBalance(Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString(), amount);
        this.plugin.getDatabaseManager().createTransaction("VAULT", Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString(), amount);
        return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.SUCCESS, "Error depositing money");
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        this.plugin.getDatabaseManager().addBalance(Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString(), amount);
        this.plugin.getDatabaseManager().createTransaction("VAULT", Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString(), amount);
        return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.SUCCESS, "Error depositing money");
    }

    public EconomyResponse createBank(String name, String player) {
        return null;
    }

    public EconomyResponse deleteBank(String name) {
        return null;
    }

    public EconomyResponse bankBalance(String name) {
        return null;
    }

    public EconomyResponse bankHas(String name, double amount) {
        return null;
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return null;
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return null;
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return null;
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return null;
    }

    public List<String> getBanks() {
        return null;
    }

    public boolean createPlayerAccount(String playerName) {
        this.plugin.getDatabaseManager().createAccount(Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString());
        return true;
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        this.plugin.getDatabaseManager().createAccount(Bukkit.getOfflinePlayer((String)playerName).getUniqueId().toString());
        return true;
    }
}

