/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.item;

import java.util.List;
import net.Pandarix.config.BAConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TorrentTotemItem
extends Item {
    public TorrentTotemItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pUsedHand);
        if (!BAConfig.torrentTotemEnabled || !BAConfig.totemsEnabled) {
            if (pLevel.isClientSide()) {
                pPlayer.displayClientMessage((Component)Component.translatableWithFallback((String)"config.notify.disabled", (String)"This feature has been disabled in the config!"), true);
            }
            return InteractionResultHolder.pass((Object)itemStack);
        }
        Vec3 rotationVector = pPlayer.getLookAngle();
        Vec3 velocity = pPlayer.getDeltaMovement();
        double boostX = 2.0 * BAConfig.torrentTotemBoost;
        double boostY = BAConfig.torrentTotemUpwardsBoost ? 0.5 * BAConfig.torrentTotemBoost : 0.0;
        pPlayer.setDeltaMovement(velocity.add(rotationVector.x * 0.1 + (rotationVector.x * 1.5 - velocity.x) * boostX, (rotationVector.y * 0.1 + (rotationVector.y * 1.5 - velocity.y)) * boostY, rotationVector.z * 0.1 + (rotationVector.z * 1.5 - velocity.z) * boostX));
        pPlayer.startAutoSpinAttack(8, 2.0f, itemStack);
        pLevel.playSound(null, (Entity)pPlayer, SoundEvents.WATER_AMBIENT, SoundSource.NEUTRAL, 0.1f, (float)pLevel.getRandom().nextDouble() * 0.5f + 0.5f);
        pLevel.playSound(null, (Entity)pPlayer, SoundEvents.PLAYER_SPLASH_HIGH_SPEED, SoundSource.NEUTRAL, 0.25f, 0.35f / (pLevel.getRandom().nextFloat() * 0.4f + 0.8f));
        pPlayer.getCooldowns().addCooldown((Item)this, 120);
        itemStack.hurtAndBreak(1, (LivingEntity)pPlayer, pPlayer.getEquipmentSlotForItem(itemStack));
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)"item.betterarcheology.torrent_totem_description").withStyle(ChatFormatting.DARK_AQUA));
    }

    public int getUseDuration(ItemStack pStack, LivingEntity pEntity) {
        return 0;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack pStack) {
        return UseAnim.BOW;
    }
}

