/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvokerTrapBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<EvokerTrapBlock> CODEC = EvokerTrapBlock.simpleCodec(EvokerTrapBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty TRIGGERED = BooleanProperty.create((String)"triggered");
    private static final int fangCooldown = 40;
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public EvokerTrapBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, @Nullable Orientation orientation, boolean bl) {
        super.neighborChanged(blockState, level, blockPos, block, orientation, bl);
        boolean powered = level.hasNeighborSignal(blockPos) || level.hasNeighborSignal(blockPos.above());
        boolean active = (Boolean)blockState.getValue((Property)ACTIVE);
        if (powered && !active) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
            this.spawnFangs(blockState, level, blockPos, level.getRandom());
            level.scheduleTick(blockPos, (Block)this, 40);
        } else if (!powered && active) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    private void spawnFangs(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.isClientSide()) {
            return;
        }
        int maxFangs = 3;
        switch ((Direction)state.getValue(FACING)) {
            case NORTH: {
                for (int i = 0; i < maxFangs; ++i) {
                    level.addFreshEntity((Entity)new EvokerFangs(level, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() - 0.5 - (double)i * 1.5, (float)Math.toRadians(90.0), 0, null));
                }
                break;
            }
            case SOUTH: {
                for (int i = 0; i < maxFangs; ++i) {
                    level.addFreshEntity((Entity)new EvokerFangs(level, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 1.5 + (double)i * 1.5, (float)Math.toRadians(90.0), 0, null));
                }
                break;
            }
            case EAST: {
                for (int i = 0; i < maxFangs; ++i) {
                    level.addFreshEntity((Entity)new EvokerFangs(level, (double)pos.getX() + 1.5 + (double)i * 1.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0, null));
                }
                break;
            }
            case WEST: {
                for (int i = 0; i < maxFangs; ++i) {
                    level.addFreshEntity((Entity)new EvokerFangs(level, (double)pos.getX() - 0.5 - (double)i * 1.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0, null));
                }
                break;
            }
            default: {
                for (int i = 0; i < maxFangs; ++i) {
                    level.addFreshEntity((Entity)new EvokerFangs(level, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() - 0.5 - (double)i * 1.5, 0.0f, 0, null));
                }
            }
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING, TRIGGERED, ACTIVE});
    }
}

