/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.block.custom;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.Pandarix.block.custom.FossilBaseWithEntityBlock;
import net.Pandarix.block.entity.GuardianFossilBlockEntity;
import net.Pandarix.block.entity.ModBlockEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuardianFossilBlock
extends FossilBaseWithEntityBlock
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Map<Direction, VoxelShape> SHAPES_FOR_DIRECTION = ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)-2.0, (double)15.0, (double)15.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)23.0), Block.box((double)7.0, (double)2.0, (double)23.0, (double)9.0, (double)14.0, (double)32.0)}), (Object)Direction.SOUTH, (Object)Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)4.0, (double)15.0, (double)15.0, (double)18.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)4.0, (double)-7.0, (double)12.0, (double)12.0, (double)4.0), Block.box((double)7.0, (double)2.0, (double)-16.0, (double)9.0, (double)14.0, (double)-7.0)}), (Object)Direction.WEST, (Object)Shapes.or((VoxelShape)Block.box((double)-2.0, (double)0.0, (double)1.0, (double)12.0, (double)15.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)12.0, (double)4.0, (double)4.0, (double)23.0, (double)12.0, (double)12.0), Block.box((double)23.0, (double)2.0, (double)7.0, (double)32.0, (double)14.0, (double)9.0)}), (Object)Direction.EAST, (Object)Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)1.0, (double)18.0, (double)15.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)-7.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0), Block.box((double)-16.0, (double)2.0, (double)7.0, (double)-7.0, (double)14.0, (double)9.0)}));

    public GuardianFossilBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.isSourceOfType((Fluid)Fluids.WATER)))).setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return GuardianFossilBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.GUARDIAN_FOSSIL.get()), GuardianFossilBlockEntity::tick);
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPES_FOR_DIRECTION.get(blockState.getValue((Property)FACING));
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GuardianFossilBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> component, TooltipFlag flag) {
        component.add((Component)Component.translatable((String)"block.betterarcheology.guardian_fossil_tooltip").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, component, flag);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{WATERLOGGED, FACING});
    }
}

