/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.Pandarix.block.entity.ModBlockEntities;
import net.Pandarix.block.entity.RadianceTotemBlockEntity;
import net.Pandarix.config.BAConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadianceTotemBlock
extends BaseEntityBlock {
    public static final BooleanProperty HANGING = BlockStateProperties.HANGING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty SELECTOR = IntegerProperty.create((String)"selector", (int)0, (int)3);
    public static final MapCodec<RadianceTotemBlock> CODEC = RadianceTotemBlock.simpleCodec(RadianceTotemBlock::new);
    protected static final VoxelShape AABB = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0), (VoxelShape)Block.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
    protected static final VoxelShape HANGING_AABB = Shapes.or((VoxelShape)Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (VoxelShape)Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));

    public RadianceTotemBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)SELECTOR, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return RadianceTotemBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.RADIANCE_TOTEM.get()), RadianceTotemBlockEntity::tick);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RadianceTotemBlockEntity(pos, state);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.animateTick(pState, pLevel, pPos, pRandom);
        if (pRandom.nextBoolean() && pLevel.isClientSide()) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.GLOW, pPos.getCenter().x() + (double)RadianceTotemBlock.randomDirectionModifier(pRandom, 3), pPos.getCenter().y() - 0.25 + (double)RadianceTotemBlock.randomDirectionModifier(pRandom, 5), pPos.getCenter().z() + (double)RadianceTotemBlock.randomDirectionModifier(pRandom, 3), 0.0, -4.0, 0.0);
        }
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (!pState.is((Block)this)) {
            return InteractionResult.PASS;
        }
        if (!BAConfig.radianceTotemEnabled || !BAConfig.totemsEnabled) {
            if (pLevel.isClientSide()) {
                pPlayer.displayClientMessage((Component)Component.translatableWithFallback((String)"config.notify.disabled", (String)"This feature has been disabled in the config!"), true);
            }
            return InteractionResult.PASS;
        }
        BlockState newState = (BlockState)pState.cycle((Property)SELECTOR);
        pLevel.setBlock(pPos, newState, 3);
        if (pLevel.isClientSide()) {
            pPlayer.displayClientMessage((Component)Component.translatable((String)("block.betterarcheology.radiance_totem_message_" + String.valueOf(newState.getValue((Property)SELECTOR)))).withStyle(ChatFormatting.GREEN), true);
            pLevel.playLocalSound(pPos, SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.BLOCKS, 0.5f, 0.5f, false);
            RandomSource random = pLevel.getRandom();
            for (int i = 0; i <= 10; ++i) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.GLOW, pPos.getCenter().x() + (double)RadianceTotemBlock.randomDirectionModifier(random, 3), pPos.getCenter().y() - 0.25 + (double)RadianceTotemBlock.randomDirectionModifier(random, 5), pPos.getCenter().z() + (double)RadianceTotemBlock.randomDirectionModifier(random, 3), 0.0, -4.0, 0.0);
            }
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHitResult);
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return true;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.randomTick(pState, pLevel, pPos, pRandom);
    }

    private static float randomDirectionModifier(RandomSource pRandom, int pReduce) {
        return pRandom.nextFloat() / (float)pReduce * (float)pRandom.nextIntBetweenInclusive(-1, 1);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltip, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltip, pTooltipFlag);
        pTooltip.add((Component)Component.translatable((String)"block.betterarcheology.radiance_totem_tooltip").withStyle(ChatFormatting.DARK_GREEN));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        for (Direction direction : pContext.getNearestLookingDirections()) {
            BlockState blockstate;
            if (direction.getAxis() != Direction.Axis.Y || !(blockstate = (BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).canSurvive((LevelReader)pContext.getLevel(), pContext.getClickedPos())) continue;
            return (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        }
        return null;
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)pState.getValue((Property)HANGING) != false ? HANGING_AABB : AABB;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{HANGING, WATERLOGGED, SELECTOR});
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = RadianceTotemBlock.getConnectedDirection(pState).getOpposite();
        return Block.canSupportCenter((LevelReader)pLevel, (BlockPos)pPos.relative(direction), (Direction)direction.getOpposite());
    }

    protected static Direction getConnectedDirection(BlockState pState) {
        return (Boolean)pState.getValue((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    @NotNull
    protected BlockState updateShape(BlockState blockState, LevelReader levelReader, ScheduledTickAccess scheduledTickAccess, BlockPos blockPos, Direction direction, BlockPos blockPos2, BlockState blockState2, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
        }
        return RadianceTotemBlock.getConnectedDirection(blockState).getOpposite() == direction && !blockState.canSurvive(levelReader, blockPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(blockState, levelReader, scheduledTickAccess, blockPos, direction, blockPos2, blockState2, randomSource);
    }

    @NotNull
    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

