/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.block.custom;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.Pandarix.block.custom.FossilBaseBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SheepFossilBlock
extends FossilBaseBlock {
    public static final BooleanProperty PLAYING = BooleanProperty.create((String)"playing");
    private static final int playCooldown = 80;
    public static final IntegerProperty HORN_SOUND = IntegerProperty.create((String)"horn_sound", (int)0, (int)7);
    private static final Map<Direction, VoxelShape> SHEEP_SHAPES_FOR_DIRECTION = ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)17.75, (double)19.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)9.0, (double)0.0, (double)12.0, (double)17.75, (double)4.0), Block.box((double)3.75, (double)14.0, (double)-7.5, (double)12.0, (double)25.0, (double)5.0)}), (Object)Direction.SOUTH, (Object)Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)-3.0, (double)12.0, (double)17.75, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)9.0, (double)12.0, (double)12.0, (double)17.75, (double)16.0), Block.box((double)4.0, (double)14.0, (double)11.0, (double)12.25, (double)25.0, (double)23.5)}), (Object)Direction.EAST, (Object)Shapes.or((VoxelShape)Block.box((double)-3.0, (double)0.0, (double)4.0, (double)12.0, (double)17.75, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.box((double)12.0, (double)9.0, (double)4.0, (double)16.0, (double)17.75, (double)12.0), Block.box((double)11.0, (double)14.0, (double)3.75, (double)23.5, (double)25.0, (double)12.0)}), (Object)Direction.WEST, (Object)Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)19.0, (double)17.75, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)9.0, (double)4.0, (double)4.0, (double)17.75, (double)12.0), Block.box((double)-7.5, (double)14.0, (double)4.0, (double)5.0, (double)25.0, (double)12.25)}));

    public SheepFossilBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HORN_SOUND, (Comparable)Integer.valueOf(0))).setValue((Property)PLAYING, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHEEP_SHAPES_FOR_DIRECTION.get(pState.getValue((Property)FACING));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean powered = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
        boolean playing = (Boolean)state.getValue((Property)PLAYING);
        if (powered && !playing) {
            if (!level.isClientSide()) {
                level.playSound(null, pos, (SoundEvent)((Holder.Reference)SoundEvents.GOAT_HORN_SOUND_VARIANTS.get(((Integer)state.getValue((Property)HORN_SOUND)).intValue())).value(), SoundSource.BLOCKS);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)PLAYING, (Comparable)Boolean.valueOf(true)), 3);
            level.scheduleTick(pos, (Block)this, 80);
        }
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (((Boolean)pState.getValue((Property)PLAYING)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        if (!pLevel.isClientSide()) {
            if ((Integer)pState.getValue((Property)HORN_SOUND) + 1 <= 7) {
                pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue((Property)HORN_SOUND, (Comparable)Integer.valueOf((Integer)pState.getValue((Property)HORN_SOUND) + 1))).setValue((Property)PLAYING, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue((Property)HORN_SOUND, (Comparable)Integer.valueOf(0))).setValue((Property)PLAYING, (Comparable)Boolean.valueOf(true)), 3);
            }
            pLevel.playSound(null, pPos, (SoundEvent)((Holder.Reference)SoundEvents.GOAT_HORN_SOUND_VARIANTS.get(((Integer)pLevel.getBlockState(pPos).getValue((Property)HORN_SOUND)).intValue())).value(), SoundSource.BLOCKS);
            pLevel.scheduleTick(pPos, (Block)this, 80);
        } else {
            pLevel.addParticle((ParticleOptions)ParticleTypes.NOTE, (double)pPos.getX() + 0.5, (double)pPos.getY() + 1.5, (double)pPos.getZ() + 0.5, 0.0, 0.2, 0.0);
        }
        return InteractionResult.SUCCESS;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)PLAYING, (Comparable)Boolean.valueOf(false)), 3);
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{HORN_SOUND, PLAYING});
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        pTooltipComponents.add((Component)Component.translatable((String)"block.betterarcheology.sheep_fossil_tooltip").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }
}

