/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.block.entity;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.Pandarix.BACommon;
import net.Pandarix.block.custom.ArchelogyTable;
import net.Pandarix.block.entity.ModBlockEntities;
import net.Pandarix.item.BetterBrushItem;
import net.Pandarix.recipe.IdentifyingRecipe;
import net.Pandarix.screen.IdentifyingMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArcheologyTableBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    public static final int INV_SIZE = 3;
    public static final int NO_PROP_DELEGATES = 2;
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> ArcheologyTableBlockEntity.this.progress;
                case 1 -> ArcheologyTableBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    ArcheologyTableBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ArcheologyTableBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;

    public ArcheologyTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ARCHEOLOGY_TABLE.get(), pos, state);
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory) {
        return new IdentifyingMenu(id, inventory, (Container)this, this.data);
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public int getProgress() {
        return this.progress;
    }

    private static Optional<RecipeHolder<IdentifyingRecipe>> getRecipeOrRandomMatching(SingleRecipeInput singleRecipeInput, ServerLevel serverLevel) {
        List<RecipeHolder> possibleRecipes = serverLevel.getServer().getRecipeManager().getRecipes().stream().filter(recipeHolder -> recipeHolder.value().getType() == IdentifyingRecipe.Type.INSTANCE).map(recipeHolder -> recipeHolder.value() instanceof IdentifyingRecipe ? recipeHolder : null).filter(Objects::nonNull).filter(recipeHolder -> ((IdentifyingRecipe)recipeHolder.value()).matches(singleRecipeInput, (Level)serverLevel)).toList();
        int size = possibleRecipes.size();
        return switch (size) {
            case 0 -> Optional.empty();
            case 1 -> Optional.of(possibleRecipes.getFirst());
            default -> Optional.of(possibleRecipes.get(serverLevel.random.nextInt(size)));
        };
    }

    public static void tick(Level world, BlockPos blockPos, BlockState blockState, ArcheologyTableBlockEntity entity) {
        if (world.isClientSide()) {
            return;
        }
        ItemStack brushSlotContent = (ItemStack)entity.items.getFirst();
        boolean hasBrush = brushSlotContent.getItem() instanceof BrushItem;
        ItemStack inputSlotContent = (ItemStack)entity.items.get(1);
        if (hasBrush && !inputSlotContent.isEmpty()) {
            int brushSpeed;
            SingleRecipeInput singleRecipeInput = new SingleRecipeInput(inputSlotContent);
            ServerLevel serverLevel = (ServerLevel)world;
            Optional<RecipeHolder<IdentifyingRecipe>> recipeHolder = ArcheologyTableBlockEntity.getRecipeOrRandomMatching(singleRecipeInput, serverLevel);
            if (recipeHolder.isEmpty() || !ArcheologyTableBlockEntity.canBrush(serverLevel.registryAccess(), recipeHolder.get(), singleRecipeInput, entity.items, entity.getMaxStackSize())) {
                ArcheologyTableBlockEntity.setBlockBrushing(world, blockPos, blockState, false);
                entity.resetProgress();
                return;
            }
            Item item = brushSlotContent.getItem();
            if (item instanceof BetterBrushItem) {
                BetterBrushItem betterBrushItem = (BetterBrushItem)item;
                v0 = betterBrushItem.getBrushingSpeed();
            } else {
                v0 = brushSpeed = 10;
            }
            if (entity.progress % brushSpeed == 0) {
                world.playSound(null, entity.worldPosition, SoundEvents.BRUSH_GENERIC, SoundSource.BLOCKS, 0.25f, 1.0f);
            }
            int progressStep = (int)Math.ceil(10.0f / (float)brushSpeed);
            entity.progress += progressStep;
            ArcheologyTableBlockEntity.setBlockBrushing(world, blockPos, blockState, true);
            ArcheologyTableBlockEntity.setChanged((Level)world, (BlockPos)blockPos, (BlockState)blockState);
            if (entity.progress >= entity.maxProgress) {
                entity.craftItem(serverLevel, recipeHolder.get(), singleRecipeInput, entity.items);
            }
        } else {
            entity.resetProgress();
            ArcheologyTableBlockEntity.setBlockBrushing(world, blockPos, blockState, false);
            entity.setChanged();
        }
    }

    private static void setBlockBrushing(Level world, BlockPos blockPos, BlockState blockState, boolean brushing) {
        world.setBlock(blockPos, (BlockState)blockState.setValue((Property)ArchelogyTable.DUSTING, (Comparable)Boolean.valueOf(brushing)), 3);
        ArcheologyTableBlockEntity.setChanged((Level)world, (BlockPos)blockPos, (BlockState)blockState);
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipeHolder) {
        if (recipeHolder != null) {
            ResourceLocation resourceLocation = recipeHolder.id().location();
            this.recipesUsed.addTo((Object)resourceLocation, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    private void craftItem(ServerLevel serverLevel, RecipeHolder<IdentifyingRecipe> recipeHolder, SingleRecipeInput singleRecipeInput, NonNullList<ItemStack> contents) {
        if (recipeHolder == null || !ArcheologyTableBlockEntity.canBrush(serverLevel.registryAccess(), recipeHolder, singleRecipeInput, contents, this.getMaxStackSize())) {
            return;
        }
        ItemStack stack = (ItemStack)this.items.get(1);
        stack.shrink(1);
        this.items.set(1, (Object)stack);
        ItemStack brush = (ItemStack)this.items.getFirst();
        brush.hurtAndBreak(1, serverLevel, null, item -> serverLevel.playSound(null, this.worldPosition, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 0.25f, 1.0f));
        serverLevel.playSound(null, this.worldPosition, SoundEvents.BRUSH_SAND_COMPLETED, SoundSource.BLOCKS, 0.5f, 1.0f);
        this.setRecipeUsed(recipeHolder);
        ItemStack resultStack = ((IdentifyingRecipe)recipeHolder.value()).assemble(singleRecipeInput, (HolderLookup.Provider)serverLevel.registryAccess());
        ItemStack stackInOutput = ((ItemStack)contents.get(2)).copy();
        if (stackInOutput.isEmpty()) {
            this.items.set(2, (Object)resultStack.copy());
        } else if (ItemStack.isSameItemSameComponents((ItemStack)stackInOutput, (ItemStack)resultStack)) {
            stackInOutput.grow(resultStack.getCount());
            this.items.set(2, (Object)stackInOutput);
        }
        this.resetProgress();
        this.setChanged();
    }

    private static boolean canBrush(RegistryAccess registryAccess, @Nullable RecipeHolder<IdentifyingRecipe> recipeHolder, SingleRecipeInput singleRecipeInput, NonNullList<ItemStack> nonNullList, int maxStackSize) {
        if (((ItemStack)nonNullList.getFirst()).isEmpty() || recipeHolder == null) {
            return false;
        }
        ItemStack potResult = ((IdentifyingRecipe)recipeHolder.value()).assemble(singleRecipeInput, (HolderLookup.Provider)registryAccess);
        if (potResult.isEmpty()) {
            return false;
        }
        ItemStack stackInOutput = (ItemStack)nonNullList.get(2);
        if (stackInOutput.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)potResult, (ItemStack)stackInOutput)) {
            return false;
        }
        if (potResult.getCount() < maxStackSize && stackInOutput.getCount() < stackInOutput.getMaxStackSize()) {
            return true;
        }
        return stackInOutput.getCount() < potResult.getMaxStackSize();
    }

    public int @NotNull [] getSlotsForFace(Direction direction) {
        return switch (direction) {
            case Direction.DOWN -> SLOTS_FOR_DOWN;
            case Direction.UP -> SLOTS_FOR_UP;
            default -> SLOTS_FOR_SIDES;
        };
    }

    public boolean canPlaceItemThroughFace(int slot, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        if (direction == null) {
            return false;
        }
        return switch (direction) {
            case Direction.DOWN -> false;
            case Direction.UP -> {
                if (slot == 0 && itemStack.getItem() instanceof BrushItem) {
                    yield true;
                }
                yield false;
            }
            default -> slot == 1 && ((ItemStack)this.items.get(1)).isEmpty();
        };
    }

    public boolean canTakeItemThroughFace(int slot, @NotNull ItemStack itemStack, @NotNull Direction direction) {
        return direction == Direction.DOWN && slot == 2;
    }

    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> nonNullList) {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)((ItemStack)nonNullList.get(i)));
        }
    }

    public void setItem(int i, ItemStack itemStack) {
        ItemStack itemStack2 = (ItemStack)this.items.get(i);
        boolean isValid = !itemStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemStack2, (ItemStack)itemStack);
        this.items.set(i, (Object)itemStack);
        itemStack.limitSize(this.getMaxStackSize(itemStack));
        if (i == 0 && !isValid) {
            this.setChanged();
        }
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public void fillStackedContents(StackedItemContents stackedItemContents) {
        this.items.forEach(arg_0 -> ((StackedItemContents)stackedItemContents).accountStack(arg_0));
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
        super.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        CompoundTag nbt = super.getUpdateTag(pRegistries);
        this.saveAdditional(nbt, pRegistries);
        return nbt;
    }

    protected void saveAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        pTag.putInt("archeology_table.progress", this.progress);
        CompoundTag recipesUsed = new CompoundTag();
        this.recipesUsed.forEach((resourceLocation, integer) -> recipesUsed.putInt(resourceLocation.toString(), integer.intValue()));
        pTag.put("RecipesUsed", (Tag)recipesUsed);
    }

    protected void loadAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        this.progress = pTag.getInt("archeology_table");
        CompoundTag recipesUsed = pTag.getCompound("RecipesUsed");
        recipesUsed.getAllKeys().forEach(string -> this.recipesUsed.put((Object)ResourceLocation.parse((String)string), recipesUsed.getInt(string)));
        this.setChanged();
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)BACommon.createRLoc("archeology_table").toLanguageKey());
    }

    @NotNull
    protected Component getDefaultName() {
        return this.getDisplayName();
    }
}

