/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.item;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.Pandarix.BACommon;
import net.Pandarix.item.BetterBrushItem;
import net.Pandarix.item.BombItem;
import net.Pandarix.item.SoulTotemItem;
import net.Pandarix.item.TorrentTotemItem;
import net.Pandarix.sound.ModSounds;
import net.Pandarix.util.BetterBrushTiers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;

public class ModItems {
    public static final Registrar<Item> ITEMS = BACommon.REGISTRIES.get().get(Registries.ITEM);
    public static final RegistrySupplier<Item> DISC_SWINGS = ModItems.registerItem("music_disc_swings", () -> new Item(ModItems.propsWithId("music_disc_swings").jukeboxPlayable(ModSounds.SWINGS_SONG_KEY).stacksTo(1).rarity(Rarity.RARE)));
    public static final RegistrySupplier<Item> IRON_BRUSH = ModItems.registerItem("iron_brush", () -> new BetterBrushItem(ModItems.propsWithId("iron_brush").durability(128), BetterBrushTiers.IRON));
    public static final RegistrySupplier<Item> DIAMOND_BRUSH = ModItems.registerItem("diamond_brush", () -> new BetterBrushItem(ModItems.propsWithId("diamond_brush").durability(512), BetterBrushTiers.DIAMOND));
    public static final RegistrySupplier<Item> NETHERITE_BRUSH = ModItems.registerItem("netherite_brush", () -> new BetterBrushItem(ModItems.propsWithId("netherite_brush").durability(1024).fireResistant(), BetterBrushTiers.NETHERITE));
    public static final RegistrySupplier<Item> ARTIFACT_SHARDS = ModItems.registerItem("artifact_shards", () -> new Item(ModItems.propsWithId("artifact_shards").rarity(Rarity.UNCOMMON)));
    public static final RegistrySupplier<Item> UNIDENTIFIED_ARTIFACT = ModItems.registerItem("unidentified_artifact", () -> new Item(ModItems.propsWithId("unidentified_artifact").rarity(Rarity.UNCOMMON)));
    public static final RegistrySupplier<Item> BOMB_ITEM = ModItems.registerItem("bomb", () -> new BombItem(ModItems.propsWithId("bomb").rarity(Rarity.COMMON).stacksTo(16)));
    public static final RegistrySupplier<Item> TORRENT_TOTEM = ModItems.registerItem("torrent_totem", () -> new TorrentTotemItem(ModItems.propsWithId("torrent_totem").rarity(Rarity.UNCOMMON).stacksTo(1).durability(32)));
    public static final RegistrySupplier<Item> SOUL_TOTEM = ModItems.registerItem("soul_totem", () -> new SoulTotemItem(ModItems.propsWithId("soul_totem").rarity(Rarity.UNCOMMON).stacksTo(1).durability(32)));

    public static Item.Properties propsWithId(String id) {
        return new Item.Properties().setId(BACommon.createRKey(Registries.ITEM, id));
    }

    private static <I extends Item> RegistrySupplier<I> registerItem(String id, Supplier<I> item) {
        ResourceLocation loc = BACommon.createRLoc(id);
        return ITEMS.register(loc, item);
    }

    public static void register() {
        BACommon.logRegistryEvent(ITEMS);
    }
}

