/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.item;

import java.util.List;
import java.util.function.Predicate;
import net.Pandarix.config.BAConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SoulTotemItem
extends Item {
    public SoulTotemItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public int getUseDuration(ItemStack pStack, LivingEntity pEntity) {
        return 1;
    }

    @NotNull
    public ItemUseAnimation getUseAnimation(ItemStack itemStack) {
        return ItemUseAnimation.BLOCK;
    }

    @NotNull
    public InteractionResult use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (!BAConfig.soulTotemEnabled || !BAConfig.totemsEnabled) {
            if (pLevel.isClientSide()) {
                pPlayer.displayClientMessage((Component)Component.translatableWithFallback((String)"config.notify.disabled", (String)"This feature has been disabled in the config!"), true);
            }
            return InteractionResult.PASS;
        }
        pPlayer.startUsingItem(pHand);
        return InteractionResult.CONSUME;
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        Entity entity;
        EntityHitResult entityHitResult;
        if (!(pLivingEntity instanceof Player)) {
            return pStack;
        }
        Player player = (Player)pLivingEntity;
        HitResult hitresult = ProjectileUtil.getHitResultOnViewVector((Entity)player, Predicate.not(Entity::isSpectator), (double)player.blockInteractionRange());
        if (hitresult instanceof EntityHitResult && (entityHitResult = (EntityHitResult)hitresult).getType() == HitResult.Type.ENTITY && (entity = entityHitResult.getEntity()).isAttackable()) {
            if (pLevel.isClientSide()) {
                Vec3 playerPos = player.position();
                Vec3 targetPos = entity.position();
                Vec3 toPlayerPos = playerPos.subtract(targetPos);
                for (float f = 0.0f; f <= 1.0f; f += 0.05f) {
                    pLevel.addParticle((ParticleOptions)ParticleTypes.SCULK_SOUL, this.lerp(playerPos.x, targetPos.x, f), this.lerp(playerPos.y, targetPos.y, f) + 1.0, this.lerp(playerPos.z, targetPos.z, f), toPlayerPos.x * (double)f / 15.0, toPlayerPos.y * (double)f / 15.0, toPlayerPos.z * (double)f / 15.0);
                }
            } else {
                pLevel.playSound(null, (Entity)player, SoundEvents.MULE_EAT, SoundSource.PLAYERS, 0.5f, 1.0f);
                pLevel.playSound(null, (Entity)player, SoundEvents.WITHER_SHOOT, SoundSource.PLAYERS, 0.1f, 0.25f);
                entity.hurt(entity.damageSources().playerAttack(player), 4.0f);
                player.heal(4.0f);
                player.getCooldowns().addCooldown(pStack, 180);
                pStack.hurtAndBreak(1, (LivingEntity)player, pLivingEntity.getEquipmentSlotForItem(pStack));
            }
        }
        return super.finishUsingItem(pStack, pLevel, pLivingEntity);
    }

    private double lerp(double a, double b, float f) {
        return a + (double)f * (b - a);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)"item.betterarcheology.soul_totem_description").withStyle(ChatFormatting.DARK_AQUA));
    }
}

