/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.block.custom;

import net.Pandarix.config.BAConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SpellParticleOption;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class GrowthTotemBlock
extends FlowerBlock {
    public GrowthTotemBlock(Holder<MobEffect> mobEffect, int pEffectDuration, BlockBehaviour.Properties pProperties) {
        super(mobEffect, (float)pEffectDuration, pProperties);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.animateTick(pState, pLevel, pPos, pRandom);
        if (!BAConfig.totemsEnabled || !BAConfig.growthTotemEnabled) {
            return;
        }
        if (pLevel.isClientSide() && pRandom.nextIntBetweenInclusive(0, 40) == 0) {
            for (int i = -BAConfig.growthTotemGrowRadius; i <= BAConfig.growthTotemGrowRadius; ++i) {
                for (int j = -BAConfig.growthTotemGrowRadius; j <= BAConfig.growthTotemGrowRadius; ++j) {
                    if (pRandom.nextIntBetweenInclusive(0, 3) != 3) continue;
                    SpellParticleOption particleOption = SpellParticleOption.create((ParticleType)ParticleTypes.INSTANT_EFFECT, (int)ARGB.white((float)1.0f), (float)0.0f);
                    Vec3 center = pPos.offset(i, 0, j).getCenter();
                    pLevel.addParticle((ParticleOptions)particleOption, center.x + (double)GrowthTotemBlock.randomDirectionModifier(pRandom, 3), (double)pPos.getY(), center.z + (double)GrowthTotemBlock.randomDirectionModifier(pRandom, 3), 0.0, -5.0, 0.0);
                }
            }
        }
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return true;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!BAConfig.totemsEnabled || !BAConfig.growthTotemEnabled) {
            return;
        }
        if (pRandom.nextIntBetweenInclusive(1, 100) > BAConfig.growthTotemGrowChance) {
            return;
        }
        for (int i = -BAConfig.growthTotemGrowRadius; i <= BAConfig.growthTotemGrowRadius; ++i) {
            for (int j = -BAConfig.growthTotemGrowRadius; j <= BAConfig.growthTotemGrowRadius; ++j) {
                CropBlock cropBlock;
                BlockPos pos = pPos.offset(i, 0, j);
                BlockState state = pLevel.getBlockState(pos);
                Block block = state.getBlock();
                if (!(block instanceof CropBlock) || !(cropBlock = (CropBlock)block).isValidBonemealTarget((LevelReader)pLevel, pos, state) || !cropBlock.isBonemealSuccess((Level)pLevel, pLevel.random, pos, state)) continue;
                cropBlock.performBonemeal(pLevel, pLevel.random, pos, state);
                if (!pRandom.nextBoolean()) continue;
                pLevel.playSound(null, pos, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS);
            }
        }
        super.randomTick(pState, pLevel, pPos, pRandom);
    }

    protected void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity, InsideBlockEffectApplier insideBlockEffectApplier, boolean bl) {
        super.entityInside(blockState, level, blockPos, entity, insideBlockEffectApplier, bl);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 100));
        }
    }

    private static float randomDirectionModifier(RandomSource pRandom, int pReduce) {
        return pRandom.nextFloat() / (float)pReduce * (float)pRandom.nextIntBetweenInclusive(-1, 1);
    }
}

