/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.block.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.HashCommon;
import net.Pandarix.block.entity.ArcheologyTableBlockEntity;
import net.Pandarix.block.entity.state.ArcheologyTableRenderState;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class ArcheologyTableBlockEntityRenderer
implements BlockEntityRenderer<ArcheologyTableBlockEntity, ArcheologyTableRenderState> {
    private final ItemModelResolver itemModelResolver;

    public ArcheologyTableBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    @NotNull
    public ArcheologyTableRenderState createRenderState() {
        return new ArcheologyTableRenderState();
    }

    public void extractRenderState(@NotNull ArcheologyTableBlockEntity archeologyTableBlockEntity, @NotNull ArcheologyTableRenderState archeologyTableRenderState, float f, @NotNull Vec3 vec3, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)archeologyTableBlockEntity, (BlockEntityRenderState)archeologyTableRenderState, f, vec3, crumblingOverlay);
        archeologyTableRenderState.lightCoords = archeologyTableBlockEntity.getLevel() != null ? LevelRenderer.getLightColor((BlockAndTintGetter)archeologyTableBlockEntity.getLevel(), (BlockPos)archeologyTableBlockEntity.getBlockPos().above()) : 0xF000F0;
        NonNullList<ItemStack> nonNullList = archeologyTableBlockEntity.getItems();
        int i = HashCommon.long2int((long)archeologyTableBlockEntity.getBlockPos().asLong());
        for (int j = 0; j < nonNullList.size(); ++j) {
            ItemStack itemStack = (ItemStack)nonNullList.get(j);
            if (!itemStack.isEmpty()) {
                ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
                this.itemModelResolver.updateForTopItem(itemStackRenderState, itemStack, ItemDisplayContext.FIXED, archeologyTableBlockEntity.getLevel(), (ItemOwner)archeologyTableBlockEntity, i + j);
                archeologyTableRenderState.items[j] = itemStackRenderState;
                continue;
            }
            archeologyTableRenderState.items[j] = null;
        }
    }

    public void submit(ArcheologyTableRenderState blockEntityRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        ItemStackRenderState brushRenderState = blockEntityRenderState.items[0];
        ItemStackRenderState unidentifiedRenderState = blockEntityRenderState.items[1];
        ItemStackRenderState identifiedRenderState = blockEntityRenderState.items[2];
        if (brushRenderState != null && !brushRenderState.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.35f, 1.025f, 0.7f);
            poseStack.scale(0.65f, 0.65f, 0.65f);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            if (unidentifiedRenderState != null || identifiedRenderState != null) {
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-7.5f));
            }
            brushRenderState.submit(poseStack, submitNodeCollector, blockEntityRenderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
        poseStack.pushPose();
        poseStack.translate((double)0.55f, 1.025, (double)0.4f);
        poseStack.scale(0.55f, 0.55f, 0.55f);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        if (identifiedRenderState == null || identifiedRenderState.isEmpty()) {
            if (unidentifiedRenderState != null && !unidentifiedRenderState.isEmpty()) {
                unidentifiedRenderState.submit(poseStack, submitNodeCollector, blockEntityRenderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            }
        } else {
            identifiedRenderState.submit(poseStack, submitNodeCollector, blockEntityRenderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        }
        poseStack.popPose();
    }
}

