/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.block.entity;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.Pandarix.BACommon;
import net.Pandarix.block.custom.ArchelogyTable;
import net.Pandarix.block.entity.ModBlockEntities;
import net.Pandarix.item.ModItems;
import net.Pandarix.screen.IdentifyingMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArcheologyTableBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    public static final int INV_SIZE = 3;
    public static final int NO_PROP_DELEGATES = 2;
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    protected static final ResourceKey<LootTable> CRAFTING_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BACommon.createRLoc("identifying_loot"));
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> ArcheologyTableBlockEntity.this.progress;
                case 1 -> ArcheologyTableBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    ArcheologyTableBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ArcheologyTableBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;

    public ArcheologyTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ARCHEOLOGY_TABLE.get(), pos, state);
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new IdentifyingMenu(id, inventory, (Container)this, this.data);
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public static void tick(Level world, BlockPos blockPos, BlockState blockState, ArcheologyTableBlockEntity entity) {
        if (world.isClientSide()) {
            return;
        }
        if (ArcheologyTableBlockEntity.hasRecipe(entity)) {
            if (entity.progress % 10 == 0) {
                world.playSound(null, entity.worldPosition, SoundEvents.BRUSH_GENERIC, SoundSource.BLOCKS, 0.25f, 1.0f);
            }
            world.setBlock(blockPos, (BlockState)blockState.setValue((Property)ArchelogyTable.DUSTING, (Comparable)Boolean.valueOf(true)), 3);
            ++entity.progress;
            ArcheologyTableBlockEntity.setChanged((Level)world, (BlockPos)blockPos, (BlockState)blockState);
            if (entity.progress >= entity.maxProgress) {
                entity.craftItem();
            }
        } else {
            world.setBlock(blockPos, (BlockState)blockState.setValue((Property)ArchelogyTable.DUSTING, (Comparable)Boolean.valueOf(false)), 3);
            entity.resetProgress();
            ArcheologyTableBlockEntity.setChanged((Level)world, (BlockPos)blockPos, (BlockState)blockState);
        }
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipeHolder) {
        if (recipeHolder != null) {
            ResourceLocation resourceLocation = recipeHolder.id().location();
            this.recipesUsed.addTo((Object)resourceLocation, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    private void craftItem() {
        if (ArcheologyTableBlockEntity.hasRecipe(this) && ((ItemStack)this.items.get(2)).isEmpty()) {
            ItemStack stack = (ItemStack)this.items.get(1);
            stack.shrink(1);
            this.items.set(1, (Object)stack);
            ItemStack brush = (ItemStack)this.items.get(0);
            int newDamage = brush.getDamageValue() + 1;
            if (newDamage > brush.getMaxDamage()) {
                ItemStack brushStack = (ItemStack)this.items.get(0);
                brushStack.shrink(1);
                this.items.set(0, (Object)brushStack);
                assert (this.level != null);
                if (!this.level.isClientSide()) {
                    this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 0.25f, 1.0f);
                }
            } else {
                brush.setDamageValue(newDamage);
            }
            if (this.level != null && !this.level.isClientSide()) {
                this.level.playSound(null, this.worldPosition, SoundEvents.BRUSH_SAND_COMPLETED, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            this.items.set(2, (Object)this.generateCraftingLoot((BlockEntity)this, this.level));
            this.resetProgress();
            this.setChanged();
        }
    }

    private ItemStack generateCraftingLoot(BlockEntity entity, Level level) {
        if (level != null && !level.isClientSide() && level.getServer() != null) {
            LootParams lootparams;
            LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(CRAFTING_LOOT);
            ObjectArrayList objectArrayList = lootTable.getRandomItems(lootparams = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)entity.getBlockPos())).withLuck(0.0f).create(LootContextParamSets.CHEST), level.random.nextLong());
            if (objectArrayList.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (objectArrayList.size() == 1) {
                return (ItemStack)objectArrayList.getFirst();
            }
        }
        return ItemStack.EMPTY;
    }

    private static boolean hasRecipe(ArcheologyTableBlockEntity entity) {
        boolean hasShardInFirstSlot = ((ItemStack)entity.items.get(1)).is((Item)ModItems.UNIDENTIFIED_ARTIFACT.get());
        Item itemInSlot0 = ((ItemStack)entity.items.get(0)).getItem();
        boolean hasBrushInSlot = itemInSlot0 instanceof BrushItem;
        return hasShardInFirstSlot && hasBrushInSlot && ArcheologyTableBlockEntity.canInsertAmountIntoOutputSlot(entity.items) && ArcheologyTableBlockEntity.canInsertItemIntoOutputSlot(entity.items, ((ItemStack)entity.items.get(2)).getItem());
    }

    public int @NotNull [] getSlotsForFace(Direction direction) {
        return switch (direction) {
            case Direction.DOWN -> SLOTS_FOR_DOWN;
            case Direction.UP -> SLOTS_FOR_UP;
            default -> SLOTS_FOR_SIDES;
        };
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack itemStack, @Nullable Direction direction) {
        if (direction == Direction.DOWN) {
            return false;
        }
        if (direction == Direction.UP) {
            return slot == 0 && itemStack.getItem() instanceof BrushItem;
        }
        return slot == 1 && itemStack.is((Item)ModItems.UNIDENTIFIED_ARTIFACT.get());
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack itemStack, Direction direction) {
        return direction == Direction.DOWN && slot == 2;
    }

    private static boolean canInsertItemIntoOutputSlot(NonNullList<ItemStack> handler, Item output) {
        return ((ItemStack)handler.get(2)).getItem() == output || ((ItemStack)handler.get(2)).isEmpty();
    }

    private static boolean canInsertAmountIntoOutputSlot(NonNullList<ItemStack> items) {
        return ((ItemStack)items.get(2)).getMaxStackSize() > ((ItemStack)items.get(2)).getCount();
    }

    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.set(i, (Object)((ItemStack)nonNullList.get(i)));
        }
    }

    public void setItem(int i, ItemStack itemStack) {
        ItemStack itemStack2 = (ItemStack)this.items.get(i);
        boolean isValid = !itemStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemStack2, (ItemStack)itemStack);
        this.items.set(i, (Object)itemStack);
        itemStack.limitSize(this.getMaxStackSize(itemStack));
        if (i == 0 && !isValid) {
            this.setChanged();
        }
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public void fillStackedContents(StackedItemContents stackedItemContents) {
        this.items.forEach(arg_0 -> ((StackedItemContents)stackedItemContents).accountStack(arg_0));
    }

    public void setChanged() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
        super.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag nbt = super.getUpdateTag(pRegistries);
        this.saveAdditional(nbt, pRegistries);
        return nbt;
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        pTag.putInt("archeology_table.progress", this.progress);
        CompoundTag recipesUsed = new CompoundTag();
        this.recipesUsed.forEach((resourceLocation, integer) -> recipesUsed.putInt(resourceLocation.toString(), integer.intValue()));
        pTag.put("RecipesUsed", (Tag)recipesUsed);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        this.progress = pTag.getInt("archeology_table");
        CompoundTag recipesUsed = pTag.getCompound("RecipesUsed");
        recipesUsed.getAllKeys().forEach(string -> this.recipesUsed.put((Object)ResourceLocation.parse((String)string), recipesUsed.getInt(string)));
        this.setChanged();
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)BACommon.createRLoc("archeology_table").toLanguageKey());
    }

    @NotNull
    protected Component getDefaultName() {
        return this.getDisplayName();
    }
}

