/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.neoforge;

import com.google.common.collect.ImmutableSet;
import dev.architectury.registry.registries.Registrar;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.Pandarix.BACommon;
import net.Pandarix.enchantment.ModEnchantments;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.EventHooks;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class PlatformImpl {
    public static final Registrar<PoiType> POI_TYPES = BACommon.REGISTRIES.get().get(Registries.POINT_OF_INTEREST_TYPE);
    public static final Registrar<VillagerProfession> PROFESSIONS = BACommon.REGISTRIES.get().get(Registries.VILLAGER_PROFESSION);

    public static Supplier<VillagerProfession> registerProfession(String name, Supplier<VillagerProfession> profession) {
        return PROFESSIONS.register(BACommon.createRLoc(name), profession);
    }

    public static Supplier<PoiType> registerPoiType(String name, Supplier<Block> block) {
        return POI_TYPES.register(BACommon.createRLoc(name), () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((Block)block.get()).getStateDefinition().getPossibleStates()), 1, 1));
    }

    public static void performTunneling(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, Block block, ServerPlayer serverPlayer, ItemStack stack) {
        GameType type = serverPlayer.gameMode.getGameModeForPlayer();
        if (serverPlayer.blockActionRestricted((Level)serverLevel, blockPos, type)) {
            return;
        }
        if (serverPlayer.isCreative()) {
            PlatformImpl.performBreak(serverLevel, serverPlayer, blockPos, blockState, false);
        } else {
            ItemStack copiedStack = stack.copy();
            if (stack.isEmpty() && !copiedStack.isEmpty()) {
                EventHooks.onPlayerDestroyItem((Player)serverPlayer, (ItemStack)copiedStack, (InteractionHand)InteractionHand.MAIN_HAND);
            }
            boolean canHarvest = blockState.canHarvestBlock((BlockGetter)serverLevel, blockPos, (Player)serverPlayer);
            boolean successfulBreak = PlatformImpl.performBreak(serverLevel, serverPlayer, blockPos, blockState, canHarvest);
            if (canHarvest && successfulBreak) {
                BlockEntity blockEntity = serverLevel.getBlockEntity(blockPos);
                block.playerDestroy((Level)serverLevel, (Player)serverPlayer, blockPos, blockState, blockEntity, copiedStack);
            }
        }
    }

    private static boolean performBreak(ServerLevel serverLevel, ServerPlayer player, BlockPos pos, BlockState blockState, boolean canHarvest) {
        boolean removed = blockState.onDestroyedByPlayer((Level)serverLevel, pos, (Player)player, canHarvest, serverLevel.getFluidState(pos));
        if (removed) {
            blockState.getBlock().destroy((LevelAccessor)serverLevel, pos, blockState);
        }
        return removed;
    }

    public static boolean hasSoaringWinds(Player player) {
        if (player == null) {
            return false;
        }
        try {
            Optional curios;
            Holder.Reference soaringWinds = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ModEnchantments.SOARING_WINDS_KEY);
            if (player.getItemBySlot(EquipmentSlot.CHEST).getComponents().has(DataComponents.GLIDER) && EnchantmentHelper.getTagEnchantmentLevel((Holder)soaringWinds, (ItemStack)player.getItemBySlot(EquipmentSlot.CHEST)) >= 1) {
                return true;
            }
            if (ModList.get().isLoaded("curios") && (curios = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent()) {
                return curios.map(itemHandler -> ((ICuriosItemHandler)curios.get()).findCurios(new String[]{"back"}).stream().anyMatch(slotResult -> slotResult.stack().getComponents().has(DataComponents.GLIDER) && EnchantmentHelper.getTagEnchantmentLevel((Holder)soaringWinds, (ItemStack)slotResult.stack()) >= 1)).orElse(false);
            }
        }
        catch (Exception e) {
            BACommon.LOGGER.error("Could not find enchantment in registries: " + String.valueOf(ModEnchantments.SOARING_WINDS_KEY), (Throwable)e);
        }
        return false;
    }
}

