package thelm.packagingprovider.network;

import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import thelm.packagedauto.network.ISelfHandleMessage;
import thelm.packagingprovider.PackagingProvider;
import thelm.packagingprovider.network.packet.PacketChangeBlocking;
import thelm.packagingprovider.network.packet.PacketChangeProviding;

public class PacketHandler<REQ extends ISelfHandleMessage<? extends IMessage>> implements IMessageHandler<REQ, IMessage> {

	public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel(PackagingProvider.MOD_ID);

	public static void registerPackets() {
		int id = 0;
		INSTANCE.registerMessage(get(), PacketChangeBlocking.class, id++, Side.SERVER);
		INSTANCE.registerMessage(get(), PacketChangeProviding.class, id++, Side.SERVER);
	}

	public static <REQ extends ISelfHandleMessage<? extends IMessage>> PacketHandler<REQ> get() {
		return new PacketHandler<>();
	}

	@Override
	public IMessage onMessage(REQ message, MessageContext ctx) {
		return message.onMessage(ctx);
	}
}
