/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagingprovider.event;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thelm.packagingprovider.block.BlockPackagingProvider;
import thelm.packagingprovider.network.PacketHandler;
import thelm.packagingprovider.tile.TilePackagingProvider;

public class CommonEventHandler {
    public void registerBlock(Block block) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
    }

    public void registerItem(Item item) {
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
    }

    public void onPreInit(FMLPreInitializationEvent event) {
        this.registerBlocks();
        this.registerItems();
        this.registerTileEntities();
        this.registerNetwork();
    }

    protected void registerBlocks() {
        this.registerBlock((Block)BlockPackagingProvider.INSTANCE);
    }

    protected void registerItems() {
        this.registerItem(BlockPackagingProvider.ITEM_INSTANCE);
    }

    protected void registerTileEntities() {
        GameRegistry.registerTileEntity(TilePackagingProvider.class, (ResourceLocation)new ResourceLocation("packagingprovider:packaging_provider"));
    }

    protected void registerNetwork() {
        PacketHandler.registerPackets();
    }
}

