/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagingprovider.recipe;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.integration.appeng.AppEngUtil;

public class DirectCraftingPatternHelper
implements ICraftingPatternDetails {
    public final IRecipeInfo recipe;
    public final ItemStack definition;
    public final IAEItemStack[] inputs;
    public final IAEItemStack[] outputs;
    public final IAEItemStack[] condensedInputs;
    public final IAEItemStack[] condensedOutputs;

    public DirectCraftingPatternHelper(IRecipeInfo recipe) {
        this.recipe = recipe;
        this.definition = ((IPackagePattern)recipe.getPatterns().get(0)).getOutput();
        this.definition.func_77978_p().func_74778_a("PatternType", "direct");
        IItemStorageChannel storageChannel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
        this.inputs = (IAEItemStack[])recipe.getInputs().stream().flatMap(stack -> {
            IRecipeInfo subRecipe;
            if (stack.func_77973_b() instanceof IPackageItem && !(subRecipe = ((IPackageItem)stack.func_77973_b()).getRecipeInfo(stack)).getRecipeType().hasMachine() && subRecipe.getPatterns().size() == 1) {
                return subRecipe.getInputs().stream();
            }
            return Stream.of(stack);
        }).map(arg_0 -> ((IItemStorageChannel)storageChannel).createStack(arg_0)).toArray(IAEItemStack[]::new);
        this.outputs = (IAEItemStack[])recipe.getOutputs().stream().map(arg_0 -> ((IItemStorageChannel)storageChannel).createStack(arg_0)).toArray(IAEItemStack[]::new);
        this.condensedInputs = AppEngUtil.condenseStacks((IAEItemStack[])this.inputs);
        this.condensedOutputs = AppEngUtil.condenseStacks((IAEItemStack[])this.outputs);
    }

    public ItemStack getPattern() {
        return this.definition;
    }

    public boolean isValidItemForSlot(int slotIndex, ItemStack itemStack, World world) {
        throw new IllegalStateException("Not supported.");
    }

    public boolean isCraftable() {
        return false;
    }

    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }

    public IAEItemStack[] getCondensedInputs() {
        return this.condensedInputs;
    }

    public IAEItemStack[] getCondensedOutputs() {
        return this.condensedOutputs;
    }

    public boolean canSubstitute() {
        return false;
    }

    public ItemStack getOutput(InventoryCrafting craftingInv, World world) {
        throw new IllegalStateException("Not supported.");
    }

    public int getPriority() {
        return 0;
    }

    public void setPriority(int priority) {
    }

    public boolean equals(Object obj) {
        if (obj instanceof DirectCraftingPatternHelper) {
            DirectCraftingPatternHelper other = (DirectCraftingPatternHelper)obj;
            return this.recipe.equals((Object)other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.recipe, 1);
    }
}

