/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagingprovider.tile;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageProvidingMachine;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeList;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.integration.appeng.AppEngUtil;
import thelm.packagedauto.integration.appeng.recipe.PackageCraftingPatternHelper;
import thelm.packagedauto.integration.appeng.recipe.RecipeCraftingPatternHelper;
import thelm.packagedauto.item.ItemRecipeHolder;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TilePackager;
import thelm.packagedauto.tile.TilePackagerExtension;
import thelm.packagedauto.tile.TileUnpackager;
import thelm.packagingprovider.client.gui.GuiPackagingProvider;
import thelm.packagingprovider.container.ContainerPackagingProvider;
import thelm.packagingprovider.inventory.InventoryPackagingProvider;
import thelm.packagingprovider.networking.HostHelperTilePackagingProvider;
import thelm.packagingprovider.recipe.DirectCraftingPatternHelper;

public class TilePackagingProvider
extends TileBase
implements ITickable,
IPackageProvidingMachine,
ISettingsCloneable,
IGridHost,
IActionHost,
ICraftingProvider {
    public boolean firstTick = true;
    public List<IRecipeInfo> recipeList = new ArrayList<IRecipeInfo>();
    public IPackagePattern currentPattern;
    public List<ItemStack> toSend = new ArrayList<ItemStack>();
    public EnumFacing sendDirection;
    public boolean sendOrdered;
    public boolean powered = false;
    public boolean blocking = false;
    public boolean provideDirect = true;
    public boolean providePackaging = false;
    public boolean provideUnpackaging = false;
    public int roundRobinIndex = 0;
    public HostHelperTilePackagingProvider hostHelper;

    public TilePackagingProvider() {
        this.setInventory(new InventoryPackagingProvider(this));
        this.hostHelper = new HostHelperTilePackagingProvider(this);
    }

    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packagingprovider.packaging_provider.name");
    }

    public String getConfigTypeName() {
        return "tile.packagingprovider.packaging_provider.name";
    }

    public void onLoad() {
        this.updatePowered();
    }

    public void func_73660_a() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.field_145850_b.field_72995_K) {
                this.hostHelper.postPatternChange();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.currentPattern != null) {
                this.sendPackaging();
            }
            if (!this.toSend.isEmpty()) {
                this.sendUnpackaging();
            }
        }
    }

    public ItemStack getPatternStack() {
        return this.inventory.func_70301_a(0);
    }

    public void setPatternStack(ItemStack stack) {
        this.inventory.func_70299_a(0, stack);
    }

    protected void sendPackaging() {
        if (this.currentPattern == null) {
            return;
        }
        if (this.hostHelper.isActive()) {
            IGrid grid = this.hostHelper.getNode().getGrid();
            IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            IItemStorageChannel storageChannel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
            IMEMonitor inventory = storageGrid.getInventory((IStorageChannel)storageChannel);
            IAEItemStack stack = (IAEItemStack)storageChannel.createStack((Object)this.currentPattern.getOutput());
            IAEItemStack rem = (IAEItemStack)AEApi.instance().storage().poweredInsert((IEnergySource)energyGrid, (IMEInventory)inventory, (IAEStack)stack, (IActionSource)this.hostHelper.source, Actionable.MODULATE);
            if (rem == null || rem.getStackSize() == 0L) {
                this.currentPattern = null;
            }
        }
    }

    protected void sendUnpackaging() {
        if (this.toSend.isEmpty()) {
            return;
        }
        if (this.sendDirection != null) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.sendDirection));
            if (!this.validSendTarget(tile, this.sendDirection.func_176734_d())) {
                this.sendDirection = null;
                return;
            }
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.sendDirection.func_176734_d());
            if (itemHandler == null) {
                this.sendDirection = null;
                return;
            }
            for (int i = 0; i < this.toSend.size(); ++i) {
                ItemStack stack = this.toSend.get(i);
                ItemStack stackRem = MiscUtil.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)this.sendOrdered, (boolean)false);
                this.toSend.set(i, stackRem);
            }
            this.toSend.removeIf(ItemStack::func_190926_b);
            this.func_70296_d();
        } else if (this.hostHelper.isActive()) {
            IGrid grid = this.hostHelper.getNode().getGrid();
            IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            IItemStorageChannel storageChannel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
            IMEMonitor inventory = storageGrid.getInventory((IStorageChannel)storageChannel);
            for (int i = 0; i < this.toSend.size(); ++i) {
                ItemStack is = this.toSend.get(i);
                if (is.func_190926_b()) continue;
                IAEItemStack stack = (IAEItemStack)storageChannel.createStack((Object)is);
                IAEItemStack rem = (IAEItemStack)AEApi.instance().storage().poweredInsert((IEnergySource)energyGrid, (IMEInventory)inventory, (IAEStack)stack, (IActionSource)this.hostHelper.source, Actionable.MODULATE);
                if (rem == null || rem.getStackSize() == 0L) {
                    this.toSend.set(i, ItemStack.field_190927_a);
                    continue;
                }
                this.toSend.set(i, rem.createItemStack());
            }
            this.toSend.removeIf(ItemStack::func_190926_b);
            this.func_70296_d();
        }
    }

    public void updatePowered() {
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0 != this.powered) {
            this.powered = !this.powered;
            this.func_70296_d();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    public IGridNode getActionableNode() {
        return this.hostHelper.getNode();
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.hostHelper.isActive() && !this.isBusy()) {
            IGrid grid = this.hostHelper.getNode().getGrid();
            IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            double conversion = PowerUnits.RF.convertTo(PowerUnits.AE, 1.0);
            IRecipeInfo recipe = null;
            if (patternDetails instanceof DirectCraftingPatternHelper) {
                recipe = ((DirectCraftingPatternHelper)patternDetails).recipe;
            } else if (patternDetails instanceof RecipeCraftingPatternHelper) {
                recipe = ((RecipeCraftingPatternHelper)patternDetails).recipe;
            } else if (patternDetails instanceof PackageCraftingPatternHelper) {
                double request = (double)(TilePackager.energyReq * 2) * conversion;
                if (request - energyGrid.extractAEPower(request, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4) {
                    return false;
                }
                energyGrid.extractAEPower(request, Actionable.MODULATE, PowerMultiplier.CONFIG);
                this.currentPattern = ((PackageCraftingPatternHelper)patternDetails).pattern;
                return true;
            }
            if (recipe != null) {
                double request = (double)(TilePackager.energyReq * 2 + TileUnpackager.energyUsage) * conversion;
                if (request - energyGrid.extractAEPower(request, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4) {
                    return false;
                }
                if (recipe.getRecipeType().hasMachine()) {
                    ArrayList directions = Lists.newArrayList((Object[])EnumFacing.values());
                    Collections.rotate(directions, this.roundRobinIndex);
                    for (EnumFacing facing : directions) {
                        IPackageCraftingMachine machine;
                        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                        if (!(tile instanceof IPackageCraftingMachine) || (machine = (IPackageCraftingMachine)tile).isBusy() || !machine.acceptPackage(recipe, Lists.transform((List)recipe.getInputs(), ItemStack::func_77946_l), facing.func_176734_d(), this.blocking)) continue;
                        energyGrid.extractAEPower(request, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                        this.roundRobinIndex = (this.roundRobinIndex + 1) % 6;
                        return true;
                    }
                } else {
                    ArrayList toSend = new ArrayList();
                    recipe.getInputs().stream().map(ItemStack::func_77946_l).forEach(toSend::add);
                    ArrayList directions = Lists.newArrayList((Object[])EnumFacing.values());
                    Collections.rotate(directions, this.roundRobinIndex);
                    for (EnumFacing facing : directions) {
                        IItemHandler itemHandler;
                        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                        if (!this.validSendTarget(tile, facing.func_176734_d()) || (itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) == null || this.blocking && !MiscUtil.isEmpty((IItemHandler)itemHandler)) continue;
                        boolean acceptsAll = true;
                        for (int i = 0; i < toSend.size(); ++i) {
                            ItemStack stack = (ItemStack)toSend.get(i);
                            ItemStack stackRem = MiscUtil.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false, (boolean)true);
                            acceptsAll &= stackRem.func_190916_E() < stack.func_190916_E();
                        }
                        if (!acceptsAll) continue;
                        energyGrid.extractAEPower(request, Actionable.MODULATE, PowerMultiplier.CONFIG);
                        this.sendDirection = facing;
                        this.toSend.addAll(toSend);
                        this.sendOrdered = recipe.getRecipeType().isOrdered();
                        this.roundRobinIndex = (this.roundRobinIndex + 1) % 6;
                        this.sendUnpackaging();
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    protected boolean validSendTarget(TileEntity tile, EnumFacing facing) {
        return tile != null && !(tile instanceof IPackageCraftingMachine) && !(tile instanceof TilePackager) && !(tile instanceof TilePackagerExtension) && !(tile instanceof TileUnpackager) && !AppEngUtil.isInterface((TileEntity)tile, (EnumFacing)facing.func_176734_d());
    }

    public boolean isBusy() {
        return this.powered || this.currentPattern != null || !this.toSend.isEmpty();
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.hostHelper.isActive()) {
            if (this.provideDirect) {
                this.recipeList.stream().filter(pattern -> !pattern.getOutputs().isEmpty()).map(pattern -> new DirectCraftingPatternHelper((IRecipeInfo)pattern)).forEach(pattern -> craftingTracker.addCraftingOption((ICraftingMedium)this, (ICraftingPatternDetails)pattern));
            }
            if (this.providePackaging) {
                this.recipeList.stream().filter(IRecipeInfo::isValid).flatMap(recipe -> Streams.concat((Stream[])new Stream[]{recipe.getPatterns().stream(), recipe.getExtraPatterns().stream()})).map(pattern -> new PackageCraftingPatternHelper(pattern)).forEach(pattern -> craftingTracker.addCraftingOption((ICraftingMedium)this, (ICraftingPatternDetails)pattern));
            }
            if (this.provideUnpackaging) {
                this.recipeList.stream().filter(pattern -> !pattern.getOutputs().isEmpty()).map(pattern -> new RecipeCraftingPatternHelper(pattern)).forEach(pattern -> craftingTracker.addCraftingOption((ICraftingMedium)this, (ICraftingPatternDetails)pattern));
            }
        }
    }

    @MENetworkEventSubscribe
    public void onChannelsChanged(MENetworkChannelsChanged event) {
        this.hostHelper.postPatternChange();
    }

    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange event) {
        this.hostHelper.postPatternChange();
    }

    public void changeBlockingMode() {
        this.blocking = !this.blocking;
        this.func_70296_d();
    }

    public void changeProvideType(Type type) {
        switch (type) {
            case DIRECT: {
                boolean bl = this.provideDirect = !this.provideDirect;
                if (this.provideDirect && this.providePackaging && this.provideUnpackaging) {
                    this.provideUnpackaging = false;
                    this.providePackaging = false;
                }
                if (this.provideDirect || this.providePackaging || this.provideUnpackaging) break;
                this.provideUnpackaging = true;
                this.providePackaging = true;
                break;
            }
            case PACKAGING: {
                boolean bl = this.providePackaging = !this.providePackaging;
                if (this.provideDirect && this.providePackaging && this.provideUnpackaging) {
                    this.provideDirect = false;
                }
                if (this.provideDirect || this.providePackaging || this.provideUnpackaging) break;
                this.provideDirect = true;
                break;
            }
            case UNPACKAGING: {
                boolean bl = this.provideUnpackaging = !this.provideUnpackaging;
                if (this.provideDirect && this.providePackaging && this.provideUnpackaging) {
                    this.provideDirect = false;
                }
                if (this.provideDirect || this.providePackaging || this.provideUnpackaging) break;
                this.provideDirect = true;
            }
        }
        this.hostHelper.postPatternChange();
        this.func_70296_d();
    }

    public ISettingsCloneable.Result loadConfig(NBTTagCompound nbt, EntityPlayer player) {
        TextComponentTranslation message;
        block5: {
            this.blocking = nbt.func_74767_n("Blocking");
            this.provideDirect = nbt.func_74767_n("Direct");
            this.providePackaging = nbt.func_74767_n("Packaging");
            this.provideUnpackaging = nbt.func_74767_n("Unpackaging");
            message = null;
            if (nbt.func_74764_b("Recipes")) {
                if (this.inventory.func_70301_a(0).func_190926_b()) {
                    InventoryPlayer playerInventory = player.field_71071_by;
                    for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
                        ItemStack stack = playerInventory.func_70301_a(i);
                        if (stack.func_190926_b() || stack.func_77973_b() != ItemRecipeHolder.INSTANCE || stack.func_77942_o()) continue;
                        ItemStack stackCopy = stack.func_77979_a(1);
                        IRecipeList recipeListObj = ItemRecipeHolder.INSTANCE.getRecipeList(stackCopy);
                        List recipeList = MiscUtil.readRecipeListFromNBT((NBTTagList)nbt.func_150295_c("Recipes", 10));
                        recipeListObj.setRecipeList(recipeList);
                        ItemRecipeHolder.INSTANCE.setRecipeList(stackCopy, recipeListObj);
                        this.inventory.func_70299_a(0, stackCopy);
                        break block5;
                    }
                    message = new TextComponentTranslation("tile.packagingprovider.packaging_provider.no_holders", new Object[0]);
                } else {
                    message = new TextComponentTranslation("tile.packagingprovider.packaging_provider.holder_present", new Object[0]);
                }
            }
        }
        if (message != null) {
            return ISettingsCloneable.Result.partial(message);
        }
        return ISettingsCloneable.Result.success();
    }

    public ISettingsCloneable.Result saveConfig(NBTTagCompound nbt, EntityPlayer player) {
        nbt.func_74757_a("Blocking", this.blocking);
        nbt.func_74757_a("Direct", this.provideDirect);
        nbt.func_74757_a("Packaging", this.providePackaging);
        nbt.func_74757_a("Unpackaging", this.provideUnpackaging);
        if (!this.recipeList.isEmpty()) {
            nbt.func_74782_a("Recipes", (NBTBase)MiscUtil.writeRecipeListToNBT((NBTTagList)new NBTTagList(), this.recipeList));
        }
        return ISettingsCloneable.Result.success();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        NBTTagCompound tag;
        IRecipeInfo recipe;
        this.hostHelper.readFromNBT(nbt);
        super.func_145839_a(nbt);
        this.blocking = nbt.func_74767_n("Blocking");
        this.provideDirect = nbt.func_74767_n("Direct");
        this.providePackaging = nbt.func_74767_n("Packaging");
        this.provideUnpackaging = nbt.func_74767_n("Unpackaging");
        this.powered = nbt.func_74767_n("Powered");
        if (nbt.func_74764_b("Pattern") && (recipe = MiscUtil.readRecipeFromNBT((NBTTagCompound)(tag = nbt.func_74775_l("Pattern")))) != null) {
            List patterns = recipe.getPatterns();
            byte index = tag.func_74771_c("Index");
            if (index >= 0 && index < patterns.size()) {
                this.currentPattern = (IPackagePattern)patterns.get(index);
            }
        }
        MiscUtil.loadAllItems((NBTTagList)nbt.func_150295_c("ToSend", 10), this.toSend);
        if (nbt.func_74764_b("SendDirection")) {
            this.sendDirection = EnumFacing.func_82600_a((int)nbt.func_74771_c("SendDirection"));
        }
        this.sendOrdered = nbt.func_74767_n("SendOrdered");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Blocking", this.blocking);
        nbt.func_74757_a("Direct", this.provideDirect);
        nbt.func_74757_a("Packaging", this.providePackaging);
        nbt.func_74757_a("Unpackaging", this.provideUnpackaging);
        nbt.func_74757_a("Powered", this.powered);
        if (this.currentPattern != null) {
            NBTTagCompound tag = MiscUtil.writeRecipeToNBT((NBTTagCompound)new NBTTagCompound(), (IRecipeInfo)this.currentPattern.getRecipeInfo());
            tag.func_74774_a("Index", (byte)this.currentPattern.getIndex());
            nbt.func_74782_a("Pattern", (NBTBase)tag);
        }
        nbt.func_74782_a("ToSend", (NBTBase)MiscUtil.saveAllItems((NBTTagList)new NBTTagList(), this.toSend));
        if (this.sendDirection != null) {
            nbt.func_74774_a("SendDirection", (byte)this.sendDirection.func_176745_a());
        }
        nbt.func_74757_a("SendOrdered", this.sendOrdered);
        this.hostHelper.writeToNBT(nbt);
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiPackagingProvider(new ContainerPackagingProvider(player.field_71071_by, this));
    }

    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerPackagingProvider(player.field_71071_by, this);
    }

    public static enum Type {
        DIRECT,
        PACKAGING,
        UNPACKAGING;

    }
}

