/*
 * Decompiled with CFR 0.152.
 */
package de.ole101.rpx.client.state;

import de.ole101.rpx.extraction.ExtractionEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u0003R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000f\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\rR\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\rR\u001d\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0010\u001a\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\rR\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0010\u001a\u0004\b\u001a\u0010\u0011R\u001c\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\rR\u001f\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0010\u001a\u0004\b\u001e\u0010\u0011R\u001c\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\rR\u001f\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u000e8\u0006\u00a2\u0006\f\n\u0004\b \u0010\u0010\u001a\u0004\b!\u0010\u0011R\u001c\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010\rR\u001f\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u000e8\u0006\u00a2\u0006\f\n\u0004\b#\u0010\u0010\u001a\u0004\b$\u0010\u0011\u00a8\u0006%"}, d2={"Lde/ole101/rpx/client/state/ExtractionState;", "", "<init>", "()V", "Lde/ole101/rpx/extraction/ExtractionEvent;", "event", "", "updateFromEvent", "(Lde/ole101/rpx/extraction/ExtractionEvent;)V", "reset", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "_isExtracting", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lkotlinx/coroutines/flow/StateFlow;", "isExtracting", "Lkotlinx/coroutines/flow/StateFlow;", "()Lkotlinx/coroutines/flow/StateFlow;", "_isCompleted", "isCompleted", "", "_extractedBytes", "extractedBytes", "getExtractedBytes", "_totalBytes", "totalBytes", "getTotalBytes", "", "_currentFile", "currentFile", "getCurrentFile", "_message", "message", "getMessage", "_error", "error", "getError", "resourcepackextractor"})
public final class ExtractionState {
    @NotNull
    private final MutableStateFlow<Boolean> _isExtracting = StateFlowKt.MutableStateFlow((Object)false);
    @NotNull
    private final StateFlow<Boolean> isExtracting = FlowKt.asStateFlow(this._isExtracting);
    @NotNull
    private final MutableStateFlow<Boolean> _isCompleted = StateFlowKt.MutableStateFlow((Object)false);
    @NotNull
    private final StateFlow<Boolean> isCompleted = FlowKt.asStateFlow(this._isCompleted);
    @NotNull
    private final MutableStateFlow<Long> _extractedBytes = StateFlowKt.MutableStateFlow((Object)0L);
    @NotNull
    private final StateFlow<Long> extractedBytes = FlowKt.asStateFlow(this._extractedBytes);
    @NotNull
    private final MutableStateFlow<Long> _totalBytes = StateFlowKt.MutableStateFlow((Object)0L);
    @NotNull
    private final StateFlow<Long> totalBytes = FlowKt.asStateFlow(this._totalBytes);
    @NotNull
    private final MutableStateFlow<String> _currentFile = StateFlowKt.MutableStateFlow(null);
    @NotNull
    private final StateFlow<String> currentFile = FlowKt.asStateFlow(this._currentFile);
    @NotNull
    private final MutableStateFlow<String> _message = StateFlowKt.MutableStateFlow(null);
    @NotNull
    private final StateFlow<String> message = FlowKt.asStateFlow(this._message);
    @NotNull
    private final MutableStateFlow<String> _error = StateFlowKt.MutableStateFlow(null);
    @NotNull
    private final StateFlow<String> error = FlowKt.asStateFlow(this._error);

    @NotNull
    public final StateFlow<Boolean> isExtracting() {
        return this.isExtracting;
    }

    @NotNull
    public final StateFlow<Boolean> isCompleted() {
        return this.isCompleted;
    }

    @NotNull
    public final StateFlow<Long> getExtractedBytes() {
        return this.extractedBytes;
    }

    @NotNull
    public final StateFlow<Long> getTotalBytes() {
        return this.totalBytes;
    }

    @NotNull
    public final StateFlow<String> getCurrentFile() {
        return this.currentFile;
    }

    @NotNull
    public final StateFlow<String> getMessage() {
        return this.message;
    }

    @NotNull
    public final StateFlow<String> getError() {
        return this.error;
    }

    public final void updateFromEvent(@NotNull ExtractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ExtractionEvent extractionEvent = event;
        if (extractionEvent instanceof ExtractionEvent.Started) {
            this._isExtracting.setValue((Object)true);
            this._isCompleted.setValue((Object)false);
            this._totalBytes.setValue((Object)((ExtractionEvent.Started)event).getTotalBytes());
            this._extractedBytes.setValue((Object)0L);
            this._message.setValue((Object)"Starting...");
            this._error.setValue(null);
        } else if (extractionEvent instanceof ExtractionEvent.Progress) {
            this._extractedBytes.setValue((Object)((ExtractionEvent.Progress)event).getBytesProcessed());
            this._currentFile.setValue((Object)((ExtractionEvent.Progress)event).getFileName());
            this._message.setValue((Object)StringsKt.take((String)("Extracting " + ((ExtractionEvent.Progress)event).getFileName()), (int)60));
        } else if (extractionEvent instanceof ExtractionEvent.Message) {
            this._message.setValue((Object)((ExtractionEvent.Message)event).getText());
        } else if (extractionEvent instanceof ExtractionEvent.Error) {
            String string = ((ExtractionEvent.Error)event).getException().getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            this._error.setValue((Object)string);
            this._isExtracting.setValue((Object)false);
        } else if (extractionEvent instanceof ExtractionEvent.Completed) {
            this._isExtracting.setValue((Object)false);
            this._isCompleted.setValue((Object)true);
            this._extractedBytes.setValue(this._totalBytes.getValue());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void reset() {
        this._isExtracting.setValue((Object)false);
        this._isCompleted.setValue((Object)false);
        this._extractedBytes.setValue((Object)0L);
        this._totalBytes.setValue((Object)0L);
        this._currentFile.setValue(null);
        this._message.setValue(null);
        this._error.setValue(null);
    }
}

