/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests;

import com.jeff_media.customblockdata.CustomBlockData;
import com.ordwen.odailyquests.api.ODailyQuestsAPI;
import com.ordwen.odailyquests.api.commands.admin.AdminCommandRegistry;
import com.ordwen.odailyquests.api.commands.player.PlayerCommandRegistry;
import com.ordwen.odailyquests.api.quests.QuestTypeRegistry;
import com.ordwen.odailyquests.commands.admin.AdminCommands;
import com.ordwen.odailyquests.commands.admin.AdminCompleter;
import com.ordwen.odailyquests.commands.admin.ReloadService;
import com.ordwen.odailyquests.commands.admin.convert.ConvertCommand;
import com.ordwen.odailyquests.commands.admin.handlers.ARerollCommand;
import com.ordwen.odailyquests.commands.admin.handlers.AShowCommand;
import com.ordwen.odailyquests.commands.admin.handlers.AddCommand;
import com.ordwen.odailyquests.commands.admin.handlers.CompleteCommand;
import com.ordwen.odailyquests.commands.admin.handlers.CustomCompleteCommand;
import com.ordwen.odailyquests.commands.admin.handlers.OpenCommand;
import com.ordwen.odailyquests.commands.admin.handlers.RemoveCommand;
import com.ordwen.odailyquests.commands.admin.handlers.ResetCommand;
import com.ordwen.odailyquests.commands.admin.handlers.SetCommand;
import com.ordwen.odailyquests.commands.interfaces.InterfacesManager;
import com.ordwen.odailyquests.commands.interfaces.InventoryClickListener;
import com.ordwen.odailyquests.commands.player.PlayerCommands;
import com.ordwen.odailyquests.commands.player.PlayerCompleter;
import com.ordwen.odailyquests.commands.player.handlers.MeCommand;
import com.ordwen.odailyquests.commands.player.handlers.PRerollCommand;
import com.ordwen.odailyquests.commands.player.handlers.PShowCommand;
import com.ordwen.odailyquests.configuration.essentials.CheckForUpdate;
import com.ordwen.odailyquests.configuration.essentials.TimestampMode;
import com.ordwen.odailyquests.events.EventsManager;
import com.ordwen.odailyquests.events.restart.RestartHandler;
import com.ordwen.odailyquests.externs.IntegrationsManager;
import com.ordwen.odailyquests.files.FilesManager;
import com.ordwen.odailyquests.lib.morepaperlib.MorePaperLib;
import com.ordwen.odailyquests.quests.categories.CategoriesLoader;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import com.ordwen.odailyquests.quests.player.progression.listeners.AllCategoryQuestsCompletedListener;
import com.ordwen.odailyquests.quests.player.progression.listeners.AllQuestsCompletedListener;
import com.ordwen.odailyquests.quests.player.progression.listeners.CategoryTotalRewardReachedListener;
import com.ordwen.odailyquests.quests.player.progression.listeners.QuestCompletedListener;
import com.ordwen.odailyquests.quests.player.progression.listeners.TotalRewardReachedListener;
import com.ordwen.odailyquests.quests.player.progression.storage.DatabaseManager;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.quests.types.custom.crate.CrateOpenQuest;
import com.ordwen.odailyquests.quests.types.custom.mobs.EliteMobsQuest;
import com.ordwen.odailyquests.quests.types.custom.mobs.MythicMobsQuest;
import com.ordwen.odailyquests.quests.types.custom.vote.NuVotifierQuest;
import com.ordwen.odailyquests.quests.types.custom.vote.VotifierPlusQuest;
import com.ordwen.odailyquests.quests.types.entity.BreedQuest;
import com.ordwen.odailyquests.quests.types.entity.KillQuest;
import com.ordwen.odailyquests.quests.types.entity.ShearQuest;
import com.ordwen.odailyquests.quests.types.entity.TameQuest;
import com.ordwen.odailyquests.quests.types.global.CarveQuest;
import com.ordwen.odailyquests.quests.types.global.ExpLevelQuest;
import com.ordwen.odailyquests.quests.types.global.ExpPointsQuest;
import com.ordwen.odailyquests.quests.types.global.FireballReflectQuest;
import com.ordwen.odailyquests.quests.types.global.MilkingQuest;
import com.ordwen.odailyquests.quests.types.global.PlayerDeathQuest;
import com.ordwen.odailyquests.quests.types.inventory.GetQuest;
import com.ordwen.odailyquests.quests.types.inventory.LocationQuest;
import com.ordwen.odailyquests.quests.types.inventory.PlaceholderQuest;
import com.ordwen.odailyquests.quests.types.item.BreakQuest;
import com.ordwen.odailyquests.quests.types.item.ConsumeQuest;
import com.ordwen.odailyquests.quests.types.item.CookQuest;
import com.ordwen.odailyquests.quests.types.item.CraftQuest;
import com.ordwen.odailyquests.quests.types.item.EnchantQuest;
import com.ordwen.odailyquests.quests.types.item.FarmingQuest;
import com.ordwen.odailyquests.quests.types.item.FishQuest;
import com.ordwen.odailyquests.quests.types.item.LaunchQuest;
import com.ordwen.odailyquests.quests.types.item.PickupQuest;
import com.ordwen.odailyquests.quests.types.item.PlaceQuest;
import com.ordwen.odailyquests.quests.types.item.VillagerQuest;
import com.ordwen.odailyquests.tools.Metrics;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.TimerTask;
import com.ordwen.odailyquests.tools.UpdateChecker;
import com.ordwen.odailyquests.tools.updater.config.ConfigUpdateManager;
import com.ordwen.odailyquests.tools.updater.database.DatabaseUpdateManager;
import java.time.LocalDateTime;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ODailyQuests
extends JavaPlugin {
    public static ODailyQuests INSTANCE;
    public static MorePaperLib morePaperLib;
    private ODailyQuestsAPI API;
    private InterfacesManager interfacesManager;
    private FilesManager filesManager;
    public TimerTask timerTask;
    private ReloadService reloadService;
    private CategoriesLoader categoriesLoader;
    private DatabaseManager databaseManager;
    private RestartHandler restartHandler;
    boolean isServerStopping;

    public void onLoad() {
        INSTANCE = this;
        this.API = new ODailyQuestsAPI();
    }

    public void onEnable() {
        PluginLogger.info("Plugin is starting...");
        this.isServerStopping = false;
        ODailyQuestsAPI.disableRegistration();
        morePaperLib = new MorePaperLib((Plugin)this);
        int pluginId = 14277;
        new Metrics(this, pluginId);
        this.filesManager = new FilesManager(this);
        this.filesManager.load();
        new ConfigUpdateManager(this).runUpdates();
        this.categoriesLoader = new CategoriesLoader();
        this.interfacesManager = new InterfacesManager(this);
        this.databaseManager = new DatabaseManager(this);
        new IntegrationsManager(this).loadAllDependencies();
        CustomBlockData.registerListener((Plugin)this);
        this.registerQuestTypes();
        this.reloadService = new ReloadService(this);
        this.reloadService.reload();
        if (!this.isEnabled()) {
            return;
        }
        new DatabaseUpdateManager(this).runUpdates();
        new EventsManager(this).registerListeners();
        this.registerSubCommands();
        this.getCommand("dquests").setExecutor((CommandExecutor)new PlayerCommands(this.API.getPlayerCommandRegistry()));
        this.getCommand("dqadmin").setExecutor((CommandExecutor)new AdminCommands(this, this.API.getAdminCommandRegistry()));
        this.getCommand("dquests").setTabCompleter((TabCompleter)new PlayerCompleter(this.API.getPlayerCommandRegistry()));
        this.getCommand("dqadmin").setTabCompleter((TabCompleter)new AdminCompleter(this.API.getAdminCommandRegistry()));
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryClickListener(this.interfacesManager.getQuestsInterfaces()), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new QuestsManager(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new QuestCompletedListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AllQuestsCompletedListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AllCategoryQuestsCompletedListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TotalRewardReachedListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CategoryTotalRewardReachedListener(), (Plugin)this);
        this.restartHandler = new RestartHandler(this);
        this.restartHandler.registerSubClasses();
        if (!Bukkit.getServer().getOnlinePlayers().isEmpty()) {
            this.reloadService.loadConnectedPlayerQuests();
            PluginLogger.warn("It seems that you have reloaded the server.");
            PluginLogger.warn("Think that this can cause problems, especially in the data backup.");
            PluginLogger.warn("You should restart the server instead.");
        }
        if (TimestampMode.getTimestampMode() == 1) {
            if (this.timerTask != null) {
                this.timerTask.stop();
            }
            this.timerTask = new TimerTask(LocalDateTime.now());
        }
        PluginLogger.info("Plugin is started!");
        this.checkForSpigotUpdate();
    }

    private void registerQuestTypes() {
        QuestTypeRegistry questTypeRegistry = this.API.getQuestTypeRegistry();
        questTypeRegistry.registerQuestType("KILL", KillQuest.class);
        questTypeRegistry.registerQuestType("BREED", BreedQuest.class);
        questTypeRegistry.registerQuestType("SHEAR", ShearQuest.class);
        questTypeRegistry.registerQuestType("TAME", TameQuest.class);
        questTypeRegistry.registerQuestType("FIREBALL_REFLECT", FireballReflectQuest.class);
        questTypeRegistry.registerQuestType("ELITE_MOBS", EliteMobsQuest.class);
        questTypeRegistry.registerQuestType("MYTHIC_MOBS", MythicMobsQuest.class);
        questTypeRegistry.registerQuestType("BREAK", BreakQuest.class);
        questTypeRegistry.registerQuestType("PLACE", PlaceQuest.class);
        questTypeRegistry.registerQuestType("CRAFT", CraftQuest.class);
        questTypeRegistry.registerQuestType("PICKUP", PickupQuest.class);
        questTypeRegistry.registerQuestType("LAUNCH", LaunchQuest.class);
        questTypeRegistry.registerQuestType("CONSUME", ConsumeQuest.class);
        questTypeRegistry.registerQuestType("COOK", CookQuest.class);
        questTypeRegistry.registerQuestType("ENCHANT", EnchantQuest.class);
        questTypeRegistry.registerQuestType("FISH", FishQuest.class);
        questTypeRegistry.registerQuestType("FARMING", FarmingQuest.class);
        questTypeRegistry.registerQuestType("GET", GetQuest.class);
        questTypeRegistry.registerQuestType("LOCATION", LocationQuest.class);
        questTypeRegistry.registerQuestType("VILLAGER_TRADE", VillagerQuest.class);
        questTypeRegistry.registerQuestType("PLACEHOLDER", PlaceholderQuest.class);
        questTypeRegistry.registerQuestType("CARVE", CarveQuest.class);
        questTypeRegistry.registerQuestType("MILKING", MilkingQuest.class);
        questTypeRegistry.registerQuestType("EXP_POINTS", ExpPointsQuest.class);
        questTypeRegistry.registerQuestType("EXP_LEVELS", ExpLevelQuest.class);
        questTypeRegistry.registerQuestType("PLAYER_DEATH", PlayerDeathQuest.class);
        questTypeRegistry.registerQuestType("FIREBALL_REFLECT", FireballReflectQuest.class);
        questTypeRegistry.registerQuestType("NU_VOTIFIER", NuVotifierQuest.class);
        questTypeRegistry.registerQuestType("VOTIFIER_PLUS", VotifierPlusQuest.class);
        questTypeRegistry.registerQuestType("CRATE_OPEN", CrateOpenQuest.class);
        Map<String, Class<? extends AbstractQuest>> externalTypes = ODailyQuestsAPI.getExternalTypes();
        for (Map.Entry<String, Class<? extends AbstractQuest>> entry : externalTypes.entrySet()) {
            questTypeRegistry.registerQuestType(entry.getKey(), entry.getValue());
            PluginLogger.info("Registered external quest type: " + entry.getKey());
        }
    }

    private void registerSubCommands() {
        PlayerCommandRegistry playerCommandRegistry = this.API.getPlayerCommandRegistry();
        playerCommandRegistry.registerCommand(new PShowCommand(this.interfacesManager.getQuestsInterfaces()));
        playerCommandRegistry.registerCommand(new MeCommand(this.interfacesManager.getPlayerQuestsInterface()));
        playerCommandRegistry.registerCommand(new PRerollCommand());
        AdminCommandRegistry adminCommandRegistry = this.API.getAdminCommandRegistry();
        adminCommandRegistry.registerCommand(new AddCommand());
        adminCommandRegistry.registerCommand(new RemoveCommand());
        adminCommandRegistry.registerCommand(new ResetCommand());
        adminCommandRegistry.registerCommand(new ARerollCommand());
        adminCommandRegistry.registerCommand(new CompleteCommand());
        adminCommandRegistry.registerCommand(new CustomCompleteCommand());
        adminCommandRegistry.registerCommand(new ConvertCommand());
        adminCommandRegistry.registerCommand(new AShowCommand(this.interfacesManager.getPlayerQuestsInterface()));
        adminCommandRegistry.registerCommand(new OpenCommand(this.interfacesManager.getPlayerQuestsInterface()));
        adminCommandRegistry.registerCommand(new SetCommand());
    }

    public void registerQuestType(String name, Class<? extends AbstractQuest> questClass) {
        this.API.getQuestTypeRegistry().registerQuestType(name, questClass);
    }

    public void onDisable() {
        if (this.restartHandler != null) {
            this.restartHandler.setServerStopping();
        }
        if (this.timerTask != null) {
            this.timerTask.stop();
            this.timerTask = null;
        }
        this.reloadService.saveConnectedPlayerQuests();
        this.databaseManager.close();
        PluginLogger.info("Plugin is shutting down...");
    }

    private void checkForSpigotUpdate() {
        if (!CheckForUpdate.isCheckForUpdate()) {
            return;
        }
        PluginLogger.info("Checking for update...");
        new UpdateChecker(100990).getVersion(version -> {
            String currentVersion = this.getDescription().getVersion();
            boolean isSnapshot = currentVersion.contains("SNAPSHOT");
            String cleanCurrentVersion = currentVersion.replace("-SNAPSHOT", "");
            int comparison = UpdateChecker.compareVersions(cleanCurrentVersion, version);
            if (isSnapshot) {
                PluginLogger.warn("You're using a snapshot version: " + currentVersion);
                PluginLogger.warn("This version may contain bugs. Please report any issues to the developer.");
                if (comparison < 0) {
                    PluginLogger.warn("A new stable update is available!");
                    PluginLogger.warn("Current snapshot version: " + currentVersion + ", Stable version: " + version);
                    PluginLogger.warn("Consider updating to the latest stable release:");
                    PluginLogger.warn("https://www.spigotmc.org/resources/odailyquests.100990/");
                }
                return;
            }
            if (comparison >= 0) {
                PluginLogger.info("Plugin is up to date.");
            } else {
                PluginLogger.warn("A new update is available !");
                PluginLogger.warn("Current version : " + currentVersion + ", Available version : " + version);
                PluginLogger.warn("Please download the latest version:");
                PluginLogger.warn("https://www.spigotmc.org/resources/odailyquests.100990/");
            }
        });
    }

    public boolean isServerStopping() {
        return this.isServerStopping;
    }

    public void setServerStopping(boolean isServerStopping) {
        this.isServerStopping = isServerStopping;
    }

    public ReloadService getReloadService() {
        return this.reloadService;
    }

    public FilesManager getFilesManager() {
        return this.filesManager;
    }

    public InterfacesManager getInterfacesManager() {
        return this.interfacesManager;
    }

    public CategoriesLoader getCategoriesLoader() {
        return this.categoriesLoader;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public ODailyQuestsAPI getAPI() {
        return this.API;
    }
}

