/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.api;

import com.ordwen.odailyquests.api.commands.admin.AdminCommandRegistry;
import com.ordwen.odailyquests.api.commands.player.PlayerCommandRegistry;
import com.ordwen.odailyquests.api.quests.QuestTypeRegistry;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.util.HashMap;
import java.util.Map;

public class ODailyQuestsAPI {
    private static boolean canRegister = true;
    private static final Map<String, Class<? extends AbstractQuest>> externalTypes = new HashMap<String, Class<? extends AbstractQuest>>();
    private final QuestTypeRegistry questTypeRegistry = new QuestTypeRegistry();
    private final PlayerCommandRegistry playerCommandRegistry = new PlayerCommandRegistry();
    private final AdminCommandRegistry adminCommandRegistry = new AdminCommandRegistry();

    public static PlayerQuests getPlayerQuests(String playerName) {
        return QuestsManager.getActiveQuests().get(playerName);
    }

    public QuestTypeRegistry getQuestTypeRegistry() {
        return this.questTypeRegistry;
    }

    public PlayerCommandRegistry getPlayerCommandRegistry() {
        return this.playerCommandRegistry;
    }

    public AdminCommandRegistry getAdminCommandRegistry() {
        return this.adminCommandRegistry;
    }

    public static void registerQuestType(String type, Class<? extends AbstractQuest> questClass) {
        if (canRegister) {
            externalTypes.put(type, questClass);
        } else {
            PluginLogger.error("Cannot register quest type " + type + " because the plugin has already been enabled.");
        }
    }

    public static void disableRegistration() {
        canRegister = false;
    }

    public static Map<String, Class<? extends AbstractQuest>> getExternalTypes() {
        return externalTypes;
    }
}

