/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.admin;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.api.commands.admin.AdminCommandBase;
import com.ordwen.odailyquests.api.commands.admin.AdminCommandRegistry;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.enums.QuestsPermissions;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class AdminCommands
implements CommandExecutor {
    private final ODailyQuests plugin;
    private final AdminCommandRegistry adminCommandRegistry;

    public AdminCommands(ODailyQuests plugin, AdminCommandRegistry adminCommandRegistry) {
        this.plugin = plugin;
        this.adminCommandRegistry = adminCommandRegistry;
    }

    public boolean onCommand(CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.hasPermission(QuestsPermissions.QUESTS_ADMIN.get())) {
            this.noPermission(sender);
            return true;
        }
        if (args.length == 1) {
            if (args[0].equals("reload")) {
                this.plugin.getReloadService().reload();
                sender.sendMessage(QuestsMessages.PLUGIN_RELOADED.toString());
            } else {
                this.help(sender);
            }
        } else if (args.length >= 2) {
            AdminCommandBase handler = this.adminCommandRegistry.getCommandHandler(args[0]);
            if (handler != null) {
                if (sender.hasPermission(handler.getPermission())) {
                    handler.execute(sender, args);
                } else {
                    this.noPermission(sender);
                }
            } else {
                this.help(sender);
            }
        } else {
            this.help(sender);
        }
        return false;
    }

    private void help(CommandSender sender) {
        String msg = QuestsMessages.ADMIN_HELP.toString();
        if (msg != null) {
            sender.sendMessage(msg);
        }
    }

    private void noPermission(CommandSender sender) {
        String msg = QuestsMessages.NO_PERMISSION.toString();
        if (msg != null) {
            sender.sendMessage(msg);
        }
    }
}

