/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.admin;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.configuration.integrations.ItemsAdderEnabled;
import com.ordwen.odailyquests.configuration.integrations.NexoEnabled;
import com.ordwen.odailyquests.configuration.integrations.OraxenEnabled;
import com.ordwen.odailyquests.quests.categories.CategoriesLoader;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ReloadService {
    private final ODailyQuests plugin;
    private final CategoriesLoader categoriesLoader;

    public ReloadService(ODailyQuests plugin) {
        this.plugin = plugin;
        this.categoriesLoader = plugin.getCategoriesLoader();
    }

    public void loadConnectedPlayerQuests() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (QuestsManager.getActiveQuests().containsKey(player.getName())) continue;
            this.plugin.getDatabaseManager().loadQuestsForPlayer(player.getName());
        }
    }

    public void saveConnectedPlayerQuests() {
        HashMap<String, PlayerQuests> activeQuests = new HashMap<String, PlayerQuests>(QuestsManager.getActiveQuests());
        for (Map.Entry entry : activeQuests.entrySet()) {
            Player player = Bukkit.getPlayer((String)((String)entry.getKey()));
            if (player == null) {
                Debugger.write("Impossible to save progression for player " + (String)entry.getKey() + " because the player is offline.");
                PluginLogger.warn("Impossible to save progression for player " + (String)entry.getKey() + " because the player is offline.");
                continue;
            }
            this.plugin.getDatabaseManager().saveProgressionForPlayer(player.getName(), player.getUniqueId().toString(), (PlayerQuests)entry.getValue());
            QuestsManager.getActiveQuests().remove(entry.getKey());
        }
    }

    public void reload() {
        try {
            this.plugin.getFilesManager().load();
            ConfigFactory.registerConfigs(this.plugin.getFilesManager());
            this.plugin.getDatabaseManager().load();
            if (!(ItemsAdderEnabled.isEnabled() && !ItemsAdderEnabled.isLoaded() || OraxenEnabled.isEnabled() && !OraxenEnabled.isLoaded() || NexoEnabled.isEnabled() && !NexoEnabled.isLoaded())) {
                this.categoriesLoader.loadCategories();
                this.plugin.getInterfacesManager().initAllObjects();
            }
            this.saveConnectedPlayerQuests();
            ODailyQuests.morePaperLib.scheduling().globalRegionalScheduler().runDelayed(this::loadConnectedPlayerQuests, 20L);
        }
        catch (IllegalStateException e) {
            PluginLogger.error("An error occurred while reloading the plugin. Please check the logs for details.");
        }
    }
}

