/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.admin.convert;

import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.player.progression.QuestLoaderUtils;
import com.ordwen.odailyquests.quests.player.progression.storage.sql.SQLManager;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.util.LinkedHashMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public abstract class SQLConverter {
    protected void convertData(FileConfiguration progressionFile, SQLManager sqlManager) {
        LinkedHashMap<AbstractQuest, Progression> quests = new LinkedHashMap<AbstractQuest, Progression>();
        for (String playerUuid : progressionFile.getKeys(false)) {
            ConfigurationSection playerSection = progressionFile.getConfigurationSection(playerUuid);
            if (playerSection == null) {
                this.error("SQLConverter, 31 - The player section is null.");
                return;
            }
            long timestamp = playerSection.getLong(".timestamp");
            int achievedQuests = playerSection.getInt(".achievedQuests");
            int totalAchievedQuests = playerSection.getInt(".totalAchievedQuests");
            ConfigurationSection questsSection = playerSection.getConfigurationSection(".quests");
            if (questsSection == null) {
                this.error("SQLConverter, 43 - The quests section is null.");
                return;
            }
            for (String string : questsSection.getKeys(false)) {
                ConfigurationSection progressionSection = questsSection.getConfigurationSection(string);
                if (progressionSection == null) {
                    this.error("SQLConverter, 50 - The progression section is null.");
                    return;
                }
                int questIndex = progressionSection.getInt(".index");
                int advancement = progressionSection.getInt(".progression");
                int requiredAmount = progressionSection.getInt(".requiredAmount");
                boolean isAchieved = progressionSection.getBoolean(".isAchieved");
                Progression progression = new Progression(requiredAmount, advancement, isAchieved);
                AbstractQuest quest = QuestLoaderUtils.findQuest(playerUuid, questIndex, Integer.parseInt(string));
                if (quest == null) {
                    this.error("SQLConverter, 62 - The quest is null.");
                    return;
                }
                quests.put(quest, progression);
            }
            PlayerQuests playerQuests = new PlayerQuests(timestamp, quests);
            playerQuests.setAchievedQuests(achievedQuests);
            playerQuests.setTotalAchievedQuests(totalAchievedQuests);
            sqlManager.getSaveProgressionSQL().saveProgression(playerUuid, playerUuid, playerQuests, true);
        }
    }

    private void error(String message) {
        PluginLogger.error("An error occurred while converting YAML to SQL.");
        PluginLogger.error("If the error persists, please report it to the developer.");
        PluginLogger.error(message);
    }
}

