/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.admin.handlers;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.api.ODailyQuestsAPI;
import com.ordwen.odailyquests.api.commands.admin.AdminCommandBase;
import com.ordwen.odailyquests.api.events.QuestCompletedEvent;
import com.ordwen.odailyquests.configuration.essentials.QuestsPerCategory;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.enums.QuestsPermissions;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class CompleteCommand
extends AdminCommandBase {
    @Override
    public String getName() {
        return "complete";
    }

    @Override
    public String getPermission() {
        return QuestsPermissions.QUESTS_ADMIN.get();
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        Player target = this.getTargetPlayer(sender, args[1]);
        if (target == null) {
            return;
        }
        if (args.length < 3) {
            this.help(sender);
            return;
        }
        int questIndex = this.parseQuestIndex(sender, args[2]);
        if (questIndex == -1) {
            return;
        }
        this.complete(sender, questIndex, target);
    }

    private void complete(CommandSender sender, int questIndex, Player target) {
        if (questIndex >= 1 && questIndex <= QuestsPerCategory.getTotalQuestsAmount()) {
            Map<AbstractQuest, Progression> playerQuests = ODailyQuestsAPI.getPlayerQuests(target.getName()).getQuests();
            int index = 0;
            for (Map.Entry<AbstractQuest, Progression> entry : playerQuests.entrySet()) {
                if (index != questIndex - 1) {
                    ++index;
                    continue;
                }
                AbstractQuest quest = entry.getKey();
                Progression progression = entry.getValue();
                if (playerQuests.get(quest).isAchieved()) {
                    String msg = QuestsMessages.QUEST_ALREADY_ACHIEVED.toString();
                    if (msg != null) {
                        sender.sendMessage(msg);
                    }
                    return;
                }
                QuestCompletedEvent event = new QuestCompletedEvent(target, progression, quest);
                ODailyQuests.INSTANCE.getServer().getPluginManager().callEvent((Event)event);
                return;
            }
            return;
        }
        this.invalidQuest(sender);
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] args) {
        if (args.length == 3) {
            ArrayList<String> questNumbers = new ArrayList<String>();
            for (int i = 1; i <= QuestsPerCategory.getTotalQuestsAmount(); ++i) {
                questNumbers.add(String.valueOf(i));
            }
            return questNumbers;
        }
        if (args.length >= 4) {
            return Collections.emptyList();
        }
        return null;
    }
}

