/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.admin.handlers;

import com.ordwen.odailyquests.api.commands.admin.AdminCommandBase;
import com.ordwen.odailyquests.configuration.essentials.CustomTypes;
import com.ordwen.odailyquests.enums.QuestsPermissions;
import com.ordwen.odailyquests.quests.player.progression.PlayerProgressor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CustomCompleteCommand
extends AdminCommandBase {
    private final PlayerProgressor playerProgressor = new PlayerProgressor();

    @Override
    public String getName() {
        return "customcomplete";
    }

    @Override
    public String getPermission() {
        return QuestsPermissions.QUESTS_ADMIN.get();
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        if (Bukkit.getPlayerExact((String)args[1]) != null) {
            int amount;
            if (args.length < 4) {
                this.help(sender);
                return;
            }
            Player target = Bukkit.getPlayerExact((String)args[1]);
            if (target == null) {
                this.invalidPlayer(sender);
                return;
            }
            String questType = args[2];
            try {
                amount = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException exception) {
                this.help(sender);
                return;
            }
            this.playerProgressor.setPlayerQuestProgression(null, target, amount, questType);
        } else {
            this.help(sender);
        }
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 3) {
            return new ArrayList<String>(CustomTypes.getCustomTypes());
        }
        if (args.length >= 4) {
            return Collections.emptyList();
        }
        return null;
    }
}

