/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.interfaces;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.commands.interfaces.QuestsInterfaces;
import com.ordwen.odailyquests.commands.interfaces.playerinterface.PlayerQuestsInterface;
import com.ordwen.odailyquests.commands.interfaces.playerinterface.items.Buttons;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import org.bukkit.event.Listener;

public class InterfacesManager
implements Listener {
    private final ConfigurationFile configurationFile;
    private final PlayerQuestsInterface playerQuestsInterface;
    private final QuestsInterfaces questsInterfaces;
    private final Buttons buttons;

    public InterfacesManager(ODailyQuests oDailyQuests) {
        this.configurationFile = oDailyQuests.getFilesManager().getConfigurationFile();
        this.playerQuestsInterface = new PlayerQuestsInterface(oDailyQuests.getFilesManager().getPlayerInterfaceFile());
        this.buttons = new Buttons(this.configurationFile);
        this.questsInterfaces = new QuestsInterfaces(this.configurationFile, this.buttons);
    }

    public void initAllObjects() {
        this.buttons.initItems();
        this.loadInterfaces();
    }

    public void loadInterfaces() {
        this.loadPlayerQuestsInterface();
        this.loadQuestsInterfaces();
    }

    public void loadPlayerQuestsInterface() {
        this.playerQuestsInterface.load();
    }

    public void loadQuestsInterfaces() {
        this.questsInterfaces.loadAll();
    }

    public ConfigurationFile getConfigurationFile() {
        return this.configurationFile;
    }

    public QuestsInterfaces getQuestsInterfaces() {
        return this.questsInterfaces;
    }

    public PlayerQuestsInterface getPlayerQuestsInterface() {
        return this.playerQuestsInterface;
    }
}

