/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.interfaces;

import com.ordwen.odailyquests.commands.interfaces.QuestsInterfaces;
import com.ordwen.odailyquests.commands.interfaces.holder.CategoryHolder;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryClickListener
implements Listener {
    private final QuestsInterfaces questsInterfaces;

    public InventoryClickListener(QuestsInterfaces questsInterfaces) {
        this.questsInterfaces = questsInterfaces;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String string;
        int page;
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        ItemMeta clickedItemMeta = clickedItem.getItemMeta();
        if (clickedItemMeta == null) {
            return;
        }
        InventoryHolder inventoryHolder = event.getView().getTopInventory().getHolder();
        if (!(inventoryHolder instanceof CategoryHolder)) return;
        CategoryHolder categoryHolder = (CategoryHolder)inventoryHolder;
        try {
            int n;
            page = n = categoryHolder.page();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        String category = string = categoryHolder.category();
        event.setCancelled(true);
        if (this.questsInterfaces.isEmptyCaseItem(clickedItem) || event.getClick().isShiftClick() || event.getSlot() >= event.getView().getTopInventory().getSize() || event.getSlotType().equals((Object)InventoryType.SlotType.QUICKBAR)) {
            return;
        }
        if (clickedItemMeta.getDisplayName().equals(this.questsInterfaces.getNextPageItemName())) {
            player.closeInventory();
            player.openInventory(this.questsInterfaces.getInterfaceNextPage(category, page, player));
            return;
        } else {
            if (!clickedItemMeta.getDisplayName().equals(this.questsInterfaces.getPreviousPageItemName())) return;
            player.closeInventory();
            player.openInventory(this.questsInterfaces.getInterfacePreviousPage(category, page, player));
        }
    }
}

