/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.interfaces;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.commands.interfaces.holder.CategoryHolder;
import com.ordwen.odailyquests.commands.interfaces.playerinterface.items.Buttons;
import com.ordwen.odailyquests.configuration.functionalities.progression.ProgressBar;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.quests.categories.CategoriesLoader;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.tools.Pair;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.TextFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class QuestsInterfaces {
    private static final float INV_SIZE = 45.0f;
    private static final String EMPTY_ITEM = "empty_item";
    private final NamespacedKey requiredKey = new NamespacedKey((Plugin)ODailyQuests.INSTANCE, "odq_interface_required");
    private final ConfigurationFile configurationFile;
    private final Buttons buttons;
    private String nextPageItemName;
    private String previousPageItemName;
    private final List<ItemStack> emptyCaseItems = new ArrayList<ItemStack>();
    private final Map<String, Pair<String, List<Inventory>>> categorizedInterfaces = new HashMap<String, Pair<String, List<Inventory>>>();

    public QuestsInterfaces(ConfigurationFile configurationFile, Buttons buttons) {
        this.configurationFile = configurationFile;
        this.buttons = buttons;
    }

    public void loadAll() {
        ConfigurationSection section = this.configurationFile.getConfig().getConfigurationSection("interfaces");
        if (section == null) {
            PluginLogger.error("Interfaces section not found in the configuration file.");
            return;
        }
        this.initPaginationItemNames(section);
        this.loadAllInterfaces(section);
    }

    public void initPaginationItemNames(ConfigurationSection section) {
        this.nextPageItemName = TextFormatter.format(section.getString(".next_item_name"));
        this.previousPageItemName = TextFormatter.format(section.getString(".previous_item_name"));
    }

    public void loadAllInterfaces(ConfigurationSection section) {
        this.categorizedInterfaces.clear();
        this.emptyCaseItems.clear();
        for (String category : CategoriesLoader.getAllCategories().keySet()) {
            ConfigurationSection categorySection = section.getConfigurationSection(category);
            if (categorySection == null) {
                PluginLogger.error("Impossible to find the interface settings for category " + category + ".");
                PluginLogger.error("Please check the 'interfaces' section in the configuration file.");
                continue;
            }
            ItemStack emptyCaseItem = new ItemStack(Material.valueOf((String)categorySection.getString(EMPTY_ITEM)));
            this.emptyCaseItems.add(emptyCaseItem);
            int neededInventories = (int)Math.ceil((float)CategoriesLoader.getCategoryByName(category).size() / 45.0f);
            this.loadSelectedInterface(category, TextFormatter.format(categorySection.getString("inventory_name")), emptyCaseItem, neededInventories, CategoriesLoader.getCategoryByName(category));
        }
    }

    public void loadSelectedInterface(String category, String inventoryName, ItemStack emptyCaseItem, int neededInventories, List<AbstractQuest> quests) {
        List<Inventory> questsInventories = this.createInventories(category, inventoryName, neededInventories);
        this.populateInventories(questsInventories, emptyCaseItem, quests);
        this.categorizedInterfaces.put(category, new Pair<String, List<Inventory>>(inventoryName, questsInventories));
        PluginLogger.fine("Categorized quests interface named " + inventoryName + " successfully loaded.");
    }

    private List<Inventory> createInventories(String category, String inventoryName, int neededInventories) {
        ArrayList<Inventory> inventories = new ArrayList<Inventory>();
        for (int i = 0; i < neededInventories; ++i) {
            CategoryHolder holder = new CategoryHolder(i, category);
            Inventory inv = Bukkit.createInventory((InventoryHolder)holder, (int)54, (String)(inventoryName + " - " + (i + 1)));
            if (i > 0) {
                inv.setItem(45, this.buttons.getPreviousButton());
            }
            if (i < neededInventories - 1) {
                inv.setItem(53, this.buttons.getNextButton());
            }
            inventories.add(inv);
        }
        return inventories;
    }

    private void populateInventories(List<Inventory> inventories, ItemStack emptyCaseItem, List<AbstractQuest> quests) {
        int currentQuestIndex = 0;
        boolean allQuestsLoaded = false;
        for (Inventory inv : inventories) {
            int slotIndex = 0;
            while ((float)slotIndex < 45.0f && !allQuestsLoaded) {
                if (currentQuestIndex < quests.size()) {
                    inv.setItem(slotIndex, this.createQuestItem(quests.get(currentQuestIndex)));
                    ++slotIndex;
                    ++currentQuestIndex;
                    continue;
                }
                allQuestsLoaded = true;
            }
            this.fillEmptySlots(inv, emptyCaseItem);
        }
    }

    private ItemStack createQuestItem(AbstractQuest quest) {
        ItemStack itemStack = quest.getMenuItem();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(quest.getQuestName());
            itemMeta.setLore(quest.getQuestDesc());
            itemMeta.getPersistentDataContainer().set(this.requiredKey, PersistentDataType.STRING, (Object)quest.getRequiredAmountRaw());
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    private void fillEmptySlots(Inventory inv, ItemStack emptyCaseItem) {
        for (int i = 0; i < inv.getSize(); ++i) {
            if (inv.getItem(i) != null) continue;
            inv.setItem(i, emptyCaseItem);
        }
    }

    public Inventory getInterfacePage(String category, int page, Player player) {
        if (!this.categorizedInterfaces.containsKey(category)) {
            PluginLogger.error("Impossible to find the interface for category " + category + ". The reason is probably a misconfiguration and should be explicitly mentioned in the plugin startup logs.");
            return null;
        }
        Inventory inventory = this.categorizedInterfaces.get(category).second().get(page);
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getItemMeta() == null) continue;
            ItemMeta itemMeta = item.getItemMeta();
            PersistentDataContainer pdc = itemMeta.getPersistentDataContainer();
            String required = (String)pdc.get(this.requiredKey, PersistentDataType.STRING);
            List lore = itemMeta.getLore();
            if (lore != null) {
                List<String> updatedLore = new ArrayList<String>(lore);
                updatedLore.replaceAll(s -> s.replace("%progress%", String.valueOf(0)));
                updatedLore = this.safeReplaceAll(updatedLore, "%progressBar%", this.getProgressBar(required));
                updatedLore = this.safeReplaceAll(updatedLore, "%required%", required);
                updatedLore.replaceAll(s -> s.replace("%drawIn%", "~"));
                updatedLore.replaceAll(s -> TextFormatter.format(player, s));
                itemMeta.setLore(updatedLore);
            }
            if (itemMeta.hasDisplayName()) {
                String displayName = itemMeta.getDisplayName();
                displayName = displayName.replace("%progress%", String.valueOf(0));
                displayName = this.safeReplace(displayName, "%progressBar%", this.getProgressBar(required));
                displayName = this.safeReplace(displayName, "%required%", required);
                displayName = displayName.replace("%drawIn%", "~");
                displayName = TextFormatter.format(player, displayName);
                itemMeta.setDisplayName(displayName);
            }
            item.setItemMeta(itemMeta);
        }
        return inventory;
    }

    private String safeReplace(String input, String placeholder, String value) {
        return value != null ? input.replace(placeholder, value) : input;
    }

    private List<String> safeReplaceAll(List<String> list, String placeholder, String value) {
        if (value == null) {
            return list;
        }
        ArrayList<String> mutable = new ArrayList<String>(list);
        mutable.replaceAll(s -> s.replace(placeholder, value));
        return mutable;
    }

    private String getProgressBar(String requiredAmountRaw) {
        if (requiredAmountRaw == null || requiredAmountRaw.isEmpty()) {
            return ProgressBar.getProgressBar(0, 1);
        }
        if (requiredAmountRaw.contains("-")) {
            return ProgressBar.getProgressBar(0, 1);
        }
        return ProgressBar.getProgressBar(0, Integer.parseInt(requiredAmountRaw));
    }

    public Inventory getInterfaceFirstPage(String category, Player player) {
        return this.getInterfacePage(category, 0, player);
    }

    public Inventory getInterfaceNextPage(String category, int page, Player player) {
        return this.getInterfacePage(category, page + 1, player);
    }

    public Inventory getInterfacePreviousPage(String category, int page, Player player) {
        return this.getInterfacePage(category, page - 1, player);
    }

    public boolean isEmptyCaseItem(ItemStack itemStack) {
        return this.emptyCaseItems.contains(itemStack);
    }

    public String getNextPageItemName() {
        return this.nextPageItemName;
    }

    public String getPreviousPageItemName() {
        return this.previousPageItemName;
    }
}

