/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.player;

import com.ordwen.odailyquests.api.commands.player.PlayerCommandBase;
import com.ordwen.odailyquests.api.commands.player.PlayerCommandRegistry;
import com.ordwen.odailyquests.configuration.functionalities.CommandAliases;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class PlayerCompleter
implements TabCompleter {
    private final PlayerCommandRegistry commandRegistry;

    public PlayerCompleter(PlayerCommandRegistry commandRegistry) {
        this.commandRegistry = commandRegistry;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            for (PlayerCommandBase cmd : this.commandRegistry.getCommandHandlers()) {
                if (!sender.hasPermission(cmd.getPermission())) continue;
                List<String> aliases = CommandAliases.getSubcommandAliases(cmd.getName());
                if (CommandAliases.isKeepingOnlyAliases() && !aliases.isEmpty()) {
                    suggestions.addAll(aliases);
                    continue;
                }
                suggestions.add(cmd.getName());
                suggestions.addAll(aliases);
            }
            return (List)StringUtil.copyPartialMatches((String)args[0], suggestions, new ArrayList());
        }
        PlayerCommandBase subCommand = this.commandRegistry.getCommandHandler(args[0]);
        if (subCommand == null) {
            return Collections.emptyList();
        }
        return subCommand.onTabComplete(sender, args);
    }
}

