/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.player.handlers;

import com.ordwen.odailyquests.api.commands.player.PlayerCommandBase;
import com.ordwen.odailyquests.configuration.essentials.QuestsPerCategory;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.enums.QuestsPermissions;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PRerollCommand
extends PlayerCommandBase {
    @Override
    public String getName() {
        return "reroll";
    }

    @Override
    public String getPermission() {
        return QuestsPermissions.QUESTS_PLAYER_REROLL.get();
    }

    @Override
    public void execute(Player player, String[] args) {
        int index;
        if (args.length != 2) {
            this.help((CommandSender)player);
            return;
        }
        try {
            index = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            this.help((CommandSender)player);
            return;
        }
        this.reroll(player, index);
    }

    private void reroll(Player player, int index) {
        PlayerQuests playerQuests;
        String playerName = player.getName();
        Map<String, PlayerQuests> activeQuests = QuestsManager.getActiveQuests();
        if (index < 1 || index > activeQuests.get(playerName).getQuests().size()) {
            this.invalidQuest(player);
            return;
        }
        if (activeQuests.containsKey(playerName) && (playerQuests = activeQuests.get(playerName)).rerollQuest(index - 1, player)) {
            this.rerollConfirm(index, player);
        }
    }

    private void rerollConfirm(int index, Player target) {
        String msg = QuestsMessages.QUEST_REROLLED.toString();
        if (msg != null) {
            target.sendMessage(msg.replace("%index%", String.valueOf(index)));
        }
    }

    protected void invalidQuest(Player player) {
        String msg = QuestsMessages.INVALID_QUEST_INDEX.toString();
        if (msg != null) {
            player.sendMessage(msg);
        }
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> questNumbers = new ArrayList<String>();
            for (int i = 1; i <= QuestsPerCategory.getTotalQuestsAmount(); ++i) {
                questNumbers.add(String.valueOf(i));
            }
            return questNumbers;
        }
        return Collections.emptyList();
    }
}

