/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.commands.player.handlers;

import com.ordwen.odailyquests.api.commands.player.PlayerCommandBase;
import com.ordwen.odailyquests.commands.interfaces.QuestsInterfaces;
import com.ordwen.odailyquests.enums.QuestsMessages;
import com.ordwen.odailyquests.enums.QuestsPermissions;
import com.ordwen.odailyquests.quests.categories.CategoriesLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public class PShowCommand
extends PlayerCommandBase {
    private static final String PERMISSION_PREFIX = "odailyquests.";
    private final QuestsInterfaces questsInterfaces;

    public PShowCommand(QuestsInterfaces questsInterfaces) {
        this.questsInterfaces = questsInterfaces;
    }

    @Override
    public String getName() {
        return "show";
    }

    @Override
    public String getPermission() {
        return QuestsPermissions.QUESTS_PLAYER_SHOW.get();
    }

    @Override
    public void execute(Player player, String[] args) {
        if (args.length != 2) {
            this.help((CommandSender)player);
            return;
        }
        this.openCategory(player, args[1]);
    }

    private void openCategory(Player player, String category) {
        if (!CategoriesLoader.hasCategory(category)) {
            this.invalidCategory((CommandSender)player);
            return;
        }
        if (!player.hasPermission(PERMISSION_PREFIX + category)) {
            this.noPermissionCategory((CommandSender)player);
            return;
        }
        Inventory inventory = this.questsInterfaces.getInterfaceFirstPage(category, player);
        if (inventory == null) {
            player.sendMessage(QuestsMessages.CONFIGURATION_ERROR.toString());
            return;
        }
        player.openInventory(inventory);
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> categories = new ArrayList<String>(CategoriesLoader.getAllCategories().keySet());
            Collections.sort(categories);
            return categories;
        }
        return Collections.emptyList();
    }
}

