/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.essentials;

import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;

public class RenewTime
implements IConfigurable {
    private static final List<DateTimeFormatter> FORMATTERS = List.of(DateTimeFormatter.ofPattern("h:mma"), DateTimeFormatter.ofPattern("ha"), DateTimeFormatter.ofPattern("H:mm"), DateTimeFormatter.ofPattern("H"));
    private static final String DEFAULT_TIME = "00:00";
    private static final String DEFAULT_ZONE = "SystemDefault";
    private final ConfigurationFile configurationFile;
    private LocalTime time;
    private ZoneId zoneId;

    public RenewTime(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void load() {
        String timeStr = this.configurationFile.getConfig().getString("renew_time", DEFAULT_TIME);
        String zoneStr = this.configurationFile.getConfig().getString("renew_time_zone", DEFAULT_ZONE);
        try {
            this.time = this.parseTime(timeStr);
            this.zoneId = this.parseZone(zoneStr);
        }
        catch (IllegalArgumentException e) {
            PluginLogger.warn("Invalid time format in config: " + timeStr + ". Using default: 00:00");
            this.time = this.parseTime(DEFAULT_TIME);
        }
    }

    private LocalTime parseTime(String time) {
        time = time.toUpperCase().trim();
        for (DateTimeFormatter formatter : FORMATTERS) {
            try {
                return LocalTime.parse(time, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new IllegalArgumentException("Invalid time format: " + time);
    }

    private ZoneId parseZone(String zone) {
        if (zone.equalsIgnoreCase(DEFAULT_ZONE)) {
            return ZoneId.systemDefault();
        }
        try {
            return ZoneId.of(zone);
        }
        catch (DateTimeException e) {
            PluginLogger.warn("Invalid zone format in config: " + zone + ". Using system default.");
            return ZoneId.systemDefault();
        }
    }

    private static RenewTime getInstance() {
        return ConfigFactory.getConfig(RenewTime.class);
    }

    public static LocalTime getRenewTime() {
        return RenewTime.getInstance().time;
    }

    public static ZoneId getZoneId() {
        return RenewTime.getInstance().zoneId;
    }
}

