/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.functionalities.progression;

import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.TextFormatter;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ActionBar
implements IConfigurable {
    private final ConfigurationFile configurationFile;
    private boolean isEnabled;
    private String text;

    public ActionBar(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void load() {
        ConfigurationSection section = this.configurationFile.getConfig().getConfigurationSection("actionbar");
        if (section == null) {
            PluginLogger.error("Actionbar section is missing in the configuration file. Disabling.");
            this.isEnabled = false;
            return;
        }
        this.isEnabled = section.getBoolean("enabled");
        if (this.isEnabled) {
            this.text = TextFormatter.format(section.getString("text"));
        }
    }

    public void sendActionbarInternal(Player player, String questName) {
        if (this.isEnabled) {
            String parsedQuestName = TextFormatter.format(player, questName);
            String playerBar = TextFormatter.format(player, this.text.replace("%player%", player.getDisplayName()).replace("%questName%", parsedQuestName));
            String toSend = TextFormatter.format(playerBar);
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)toSend));
        }
    }

    private static ActionBar getInstance() {
        return ConfigFactory.getConfig(ActionBar.class);
    }

    public static void sendActionbar(Player player, String questName) {
        ActionBar.getInstance().sendActionbarInternal(player, questName);
    }
}

