/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.functionalities.progression;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.nms.NMSHandler;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.TextFormatter;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ToastNotification
implements IConfigurable {
    private static final String CONFIG_ROOT = "toast";
    private static final int CLEANUP_TICKS = 40;
    private final ConfigurationFile configurationFile;
    private boolean enabled;
    private Frame frame;
    private Material icon;
    private Integer customModelData;
    private String text;

    public ToastNotification(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void load() {
        ConfigurationSection section = this.configurationFile.getConfig().getConfigurationSection(CONFIG_ROOT);
        if (section == null) {
            PluginLogger.warn("Toast section is missing in the configuration file. Disabling.");
            this.enabled = false;
            return;
        }
        this.enabled = section.getBoolean("enabled", false);
        if (!this.enabled) {
            return;
        }
        this.frame = Frame.parse(section.getString("frame", "TASK"));
        String iconName = section.getString("icon", "PAPER");
        this.icon = this.parseMaterial(iconName);
        this.customModelData = section.isInt("custom_model_data") ? Integer.valueOf(section.getInt("custom_model_data")) : null;
        this.text = TextFormatter.format(section.getString("text", "&aQuest completed!"));
    }

    public void sendToastNotificationInternal(final Player player, String questName) {
        if (!this.enabled || player == null) {
            return;
        }
        String visibleLine = this.formatForPlayer(this.text, player, questName);
        final NamespacedKey key = new NamespacedKey((Plugin)ODailyQuests.INSTANCE, this.uniqueKey(player));
        final String json = this.buildAdvancementJson(visibleLine);
        new BukkitRunnable(){

            public void run() {
                ToastNotification.this.attemptToast(player, key, json);
            }
        }.runTask((Plugin)ODailyQuests.INSTANCE);
    }

    private void attemptToast(Player player, NamespacedKey key, String json) {
        try {
            if (!this.loadAdvancement(key, json)) {
                return;
            }
            this.awardAllCriteria(player, key);
            this.scheduleCleanup(player, key);
        }
        catch (Exception e) {
            PluginLogger.error("Unable to send toast: " + e.getMessage());
            this.safeRemoveAdvancement(key);
        }
    }

    private boolean loadAdvancement(NamespacedKey key, String json) {
        Bukkit.getUnsafe().loadAdvancement(key, json);
        Advancement adv = Bukkit.getAdvancement((NamespacedKey)key);
        if (adv == null) {
            PluginLogger.error("Failed to load advancement for key: " + String.valueOf(key));
            return false;
        }
        return true;
    }

    private void awardAllCriteria(Player player, NamespacedKey key) {
        Advancement adv = Bukkit.getAdvancement((NamespacedKey)key);
        if (adv == null) {
            return;
        }
        AdvancementProgress progress = player.getAdvancementProgress(adv);
        for (String c : adv.getCriteria()) {
            if (progress.isDone()) continue;
            progress.awardCriteria(c);
        }
    }

    private void scheduleCleanup(final Player player, final NamespacedKey key) {
        new BukkitRunnable(){

            public void run() {
                ToastNotification.this.revokeAndRemove(player, key);
            }
        }.runTaskLater((Plugin)ODailyQuests.INSTANCE, 40L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revokeAndRemove(Player player, NamespacedKey key) {
        try {
            Advancement adv = Bukkit.getAdvancement((NamespacedKey)key);
            if (adv != null) {
                AdvancementProgress p = player.getAdvancementProgress(adv);
                for (String c : adv.getCriteria()) {
                    if (!p.getAwardedCriteria().contains(c)) continue;
                    p.revokeCriteria(c);
                }
            }
        }
        catch (Exception e) {
            PluginLogger.error("Unable to revoke advancement criteria: " + e.getMessage());
        }
        finally {
            this.safeRemoveAdvancement(key);
        }
    }

    private void safeRemoveAdvancement(NamespacedKey key) {
        try {
            Bukkit.getUnsafe().removeAdvancement(key);
        }
        catch (Exception e) {
            PluginLogger.error("Unable to remove advancement: " + e.getMessage());
        }
    }

    private static ToastNotification getInstance() {
        return ConfigFactory.getConfig(ToastNotification.class);
    }

    public static void sendToastNotification(Player player, String questName) {
        ToastNotification.getInstance().sendToastNotificationInternal(player, questName);
    }

    private String uniqueKey(Player player) {
        return "toast_" + String.valueOf(player.getUniqueId()) + "_" + Long.toHexString(ThreadLocalRandom.current().nextLong());
    }

    private String buildAdvancementJson(String toastVisibleLine) {
        String iconKey = this.namespacedKeyOf(this.icon);
        String iconJson = this.buildIconJson(iconKey, this.customModelData);
        String display = "{\"icon\":" + iconJson + ",\"title\":\"" + this.jsonEscape(toastVisibleLine) + "\",\"description\":\" \",\"frame\":\"" + this.frame.json() + "\",\"announce_to_chat\":false,\"show_toast\":true,\"hidden\":true}";
        return "{\"criteria\":{\"instant\":{\"trigger\":\"minecraft:impossible\"}},\"display\":" + display + "}";
    }

    private String buildIconJson(String namespacedItemId, Integer cmd) {
        IconFormat format = this.selectIconFormat(NMSHandler.getInstance().getVersion());
        if (format == IconFormat.LEGACY_TAG) {
            return cmd == null ? "{\"item\":\"" + namespacedItemId + "\"}" : "{\"item\":\"" + namespacedItemId + "\",\"nbt\":\"{CustomModelData:" + cmd + "}\"}";
        }
        if (cmd == null) {
            return "{\"id\":\"" + namespacedItemId + "\"}";
        }
        String components = format == IconFormat.MODERN_FLOAT ? "{\"minecraft:custom_model_data\":{\"floats\":[" + cmd + "]}}" : "{\"minecraft:custom_model_data\":" + cmd + "}";
        return "{\"id\":\"" + namespacedItemId + "\",\"components\":" + components + "}";
    }

    private IconFormat selectIconFormat(String version) {
        String[] p = version.split("\\.");
        int major = this.parseIntSafe(p, 0);
        int minor = this.parseIntSafe(p, 1);
        int patch = this.parseIntSafe(p, 2);
        if (major == 1 && (minor < 20 || minor == 20 && patch <= 4)) {
            return IconFormat.LEGACY_TAG;
        }
        if (major == 1 && (minor == 20 || minor == 21 && patch <= 1)) {
            return IconFormat.MODERN_INT;
        }
        return IconFormat.MODERN_FLOAT;
    }

    private int parseIntSafe(String[] parts, int idx) {
        if (idx >= parts.length) {
            return 0;
        }
        try {
            return Integer.parseInt(parts[idx]);
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    private String namespacedKeyOf(Material mat) {
        try {
            return mat.getKey().toString();
        }
        catch (Exception exception) {
            PluginLogger.warn("Failed to get NamespacedKey for material " + String.valueOf(mat) + ", defaulting to minecraft:paper");
            return "minecraft:paper";
        }
    }

    private String jsonEscape(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
    }

    private Material parseMaterial(String name) {
        try {
            return Material.valueOf((String)name.trim().toUpperCase());
        }
        catch (Exception e) {
            PluginLogger.warn("Invalid material name '" + name + "', defaulting to PAPER.");
            return Material.PAPER;
        }
    }

    private String formatForPlayer(String template, Player player, String questName) {
        String parsedQuest = TextFormatter.format(player, questName);
        String raw = template.replace("%player%", player.getDisplayName()).replace("%questName%", parsedQuest);
        return TextFormatter.format(player, raw);
    }

    private static enum Frame {
        TASK("task"),
        GOAL("goal"),
        CHALLENGE("challenge");

        private final String json;

        private Frame(String json) {
            this.json = json;
        }

        public String json() {
            return this.json;
        }

        static Frame parse(String value) {
            if (value == null) {
                return TASK;
            }
            try {
                return Frame.valueOf(value.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                PluginLogger.warn("Invalid frame type '" + value + "', defaulting to TASK.");
                return TASK;
            }
        }
    }

    private static enum IconFormat {
        LEGACY_TAG,
        MODERN_INT,
        MODERN_FLOAT;

    }
}

