/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.configuration.integrations;

import com.ordwen.odailyquests.configuration.ConfigFactory;
import com.ordwen.odailyquests.configuration.IConfigurable;
import com.ordwen.odailyquests.files.implementations.ConfigurationFile;
import com.ordwen.odailyquests.quests.categories.CategoriesLoader;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class NPCNames
implements IConfigurable {
    private final ConfigurationFile configurationFile;
    private String playerNPCName;
    private final Map<String, String> categoryNPCNames = new HashMap<String, String>();

    public NPCNames(ConfigurationFile configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public void load() {
        ConfigurationSection section = this.configurationFile.getConfig().getConfigurationSection("npcs");
        if (section == null) {
            PluginLogger.error("NPCs names section not found in the config. NPCs names will not be loaded.");
            return;
        }
        String playerNpc = section.getString("player");
        if (playerNpc != null) {
            this.playerNPCName = playerNpc;
        }
        this.categoryNPCNames.clear();
        for (String categoryName : CategoriesLoader.getAllCategories().keySet()) {
            String categoryNpc = section.getString(categoryName);
            if (categoryNpc == null) continue;
            this.categoryNPCNames.put(categoryNpc, categoryName);
        }
    }

    private static NPCNames getInstance() {
        return ConfigFactory.getConfig(NPCNames.class);
    }

    public static String getPlayerNPCName() {
        return NPCNames.getInstance().playerNPCName;
    }

    public static String getCategoryByNPCName(String npcName) {
        return NPCNames.getInstance().categoryNPCNames.get(npcName);
    }

    public static boolean isCategoryForNPCName(String npcName) {
        return NPCNames.getInstance().categoryNPCNames.containsKey(npcName);
    }
}

