/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.enums;

public enum SQLQuery {
    MYSQL_CREATE_PLAYER_TABLE("    CREATE TABLE IF NOT EXISTS `odq_player` (\n        `player_uuid` CHAR(36) NOT NULL,\n        `player_timestamp` BIGINT NOT NULL,\n        `achieved_quests` TINYINT NOT NULL,\n        `total_achieved_quests` INT NOT NULL,\n        CONSTRAINT `odq_pk_player` PRIMARY KEY (`player_uuid`)\n    );\n"),
    MYSQL_CREATE_PROGRESSION_TABLE("    CREATE TABLE IF NOT EXISTS `odq_progression` (\n        `primary_key` INT AUTO_INCREMENT,\n        `player_uuid` CHAR(36) NOT NULL,\n        `player_quest_id` SMALLINT NOT NULL,\n        `quest_index` INT NOT NULL,\n        `advancement` INT NOT NULL,\n        `required_amount` INT NOT NULL,\n        `is_achieved` BIT NOT NULL,\n        `selected_required` INT DEFAULT NULL,\n        PRIMARY KEY (`primary_key`),\n        CONSTRAINT `odq_unique_player_quest` UNIQUE (`player_uuid`, `player_quest_id`)\n    );\n"),
    MYSQL_CREATE_PLAYER_CATEGORY_STATS_TABLE("    CREATE TABLE IF NOT EXISTS `odq_player_category_stats` (\n        `player_uuid` CHAR(36) NOT NULL,\n        `category` VARCHAR(50) NOT NULL,\n        `total_achieved_quests` INT NOT NULL,\n        PRIMARY KEY (`player_uuid`, `category`)\n    );\n"),
    MYSQL_SAVE_PLAYER("    INSERT INTO `odq_player` (`player_uuid`, `player_timestamp`, `achieved_quests`, `total_achieved_quests`)\n    VALUES (?, ?, ?, ?)\n    ON DUPLICATE KEY UPDATE\n        `player_timestamp` = VALUES(`player_timestamp`),\n        `achieved_quests` = VALUES(`achieved_quests`),\n        `total_achieved_quests` = VALUES(`total_achieved_quests`);\n"),
    MYSQL_SAVE_PROGRESS("    INSERT INTO `odq_progression` (`player_uuid`, `player_quest_id`, `quest_index`, `advancement`, `required_amount`, `is_achieved`, `selected_required`)\n    VALUES (?, ?, ?, ?, ?, ?, ?)\n    ON DUPLICATE KEY UPDATE\n        `quest_index` = VALUES(`quest_index`),\n        `advancement` = VALUES(`advancement`),\n        `required_amount` = VALUES(`required_amount`),\n        `is_achieved` = VALUES(`is_achieved`),\n        `selected_required` = VALUES(`selected_required`);\n"),
    MYSQL_SAVE_PLAYER_CATEGORY_STATS("    INSERT INTO `odq_player_category_stats` (`player_uuid`, `category`, `total_achieved_quests`)\n    VALUES (?, ?, ?)\n    ON DUPLICATE KEY UPDATE\n        `total_achieved_quests` = VALUES(`total_achieved_quests`);\n"),
    SQLITE_CREATE_PLAYER_TABLE("    CREATE TABLE IF NOT EXISTS `odq_player` (\n        `player_uuid` TEXT NOT NULL,\n        `player_timestamp` INTEGER NOT NULL,\n        `achieved_quests` INTEGER NOT NULL,\n        `total_achieved_quests` INTEGER NOT NULL,\n        PRIMARY KEY (`player_uuid`)\n    );\n"),
    SQLITE_CREATE_PROGRESSION_TABLE("    CREATE TABLE IF NOT EXISTS odq_progression (\n        primary_key INTEGER PRIMARY KEY AUTOINCREMENT,\n        player_uuid TEXT NOT NULL,\n        player_quest_id INTEGER NOT NULL,\n        quest_index INTEGER NOT NULL,\n        advancement INTEGER NOT NULL,\n        required_amount INTEGER NOT NULL,\n        is_achieved INTEGER NOT NULL,\n        selected_required INTEGER,\n        UNIQUE (player_uuid, player_quest_id)\n    );\n"),
    SQLITE_CREATE_PLAYER_CATEGORY_STATS_TABLE("    CREATE TABLE IF NOT EXISTS `odq_player_category_stats` (\n        `player_uuid` TEXT NOT NULL,\n        `category` TEXT NOT NULL,\n        `total_achieved_quests` INTEGER NOT NULL,\n        PRIMARY KEY (`player_uuid`, `category`)\n    );\n"),
    SQLITE_SAVE_PLAYER("    INSERT OR REPLACE INTO `odq_player` (`player_uuid`, `player_timestamp`, `achieved_quests`, `total_achieved_quests`)\n    VALUES (?, ?, ?, ?);\n"),
    SQLITE_SAVE_PROGRESS("    INSERT OR REPLACE INTO `odq_progression` (`player_uuid`, `player_quest_id`, `quest_index`, `advancement`, `required_amount`, `is_achieved`, `selected_required`)\n    VALUES (?, ?, ?, ?, ?, ?, ?);\n"),
    SQLITE_SAVE_PLAYER_CATEGORY_STATS("    INSERT OR REPLACE INTO `odq_player_category_stats` (`player_uuid`, `category`, `total_achieved_quests`)\n    VALUES (?, ?, ?);\n"),
    LOAD_PLAYER("    SELECT player_timestamp, achieved_quests, total_achieved_quests FROM `odq_player`\n    WHERE player_uuid = ?;\n"),
    LOAD_PROGRESS("    SELECT * FROM `odq_progression`\n    WHERE player_uuid = ?;\n"),
    LOAD_PLAYER_CATEGORY_STATS("    SELECT total_achieved_quests, category FROM `odq_player_category_stats`\n    WHERE `player_uuid` = ?;\n");

    private final String query;

    private SQLQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }
}

