/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.events;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.configuration.essentials.CustomFurnaceResults;
import com.ordwen.odailyquests.configuration.integrations.ItemsAdderEnabled;
import com.ordwen.odailyquests.configuration.integrations.NexoEnabled;
import com.ordwen.odailyquests.configuration.integrations.OraxenEnabled;
import com.ordwen.odailyquests.events.listeners.crate.CrateOpenListener;
import com.ordwen.odailyquests.events.listeners.customs.CustomFurnaceExtractListener;
import com.ordwen.odailyquests.events.listeners.entity.EntityBreedListener;
import com.ordwen.odailyquests.events.listeners.entity.EntityDeathListener;
import com.ordwen.odailyquests.events.listeners.entity.EntityTameListener;
import com.ordwen.odailyquests.events.listeners.entity.PlayerInteractEntityListener;
import com.ordwen.odailyquests.events.listeners.entity.ShearEntityListener;
import com.ordwen.odailyquests.events.listeners.entity.SpawnerSpawnListener;
import com.ordwen.odailyquests.events.listeners.entity.custom.mobs.EliteMobDeathListener;
import com.ordwen.odailyquests.events.listeners.entity.custom.mobs.MythicMobDeathListener;
import com.ordwen.odailyquests.events.listeners.entity.custom.stackers.RoseStackerListener;
import com.ordwen.odailyquests.events.listeners.entity.custom.stackers.WildStackerListener;
import com.ordwen.odailyquests.events.listeners.global.BucketFillListener;
import com.ordwen.odailyquests.events.listeners.global.PlayerDeathListener;
import com.ordwen.odailyquests.events.listeners.global.PlayerExpChangeListener;
import com.ordwen.odailyquests.events.listeners.global.PlayerInteractListener;
import com.ordwen.odailyquests.events.listeners.global.PlayerLevelChangeListener;
import com.ordwen.odailyquests.events.listeners.global.PlayerRespawnListener;
import com.ordwen.odailyquests.events.listeners.integrations.customsuite.CropBreakListener;
import com.ordwen.odailyquests.events.listeners.integrations.customsuite.FishingLootSpawnListener;
import com.ordwen.odailyquests.events.listeners.integrations.itemsadder.CustomBlockBreakListener;
import com.ordwen.odailyquests.events.listeners.integrations.itemsadder.ItemsAdderLoadDataListener;
import com.ordwen.odailyquests.events.listeners.integrations.nexo.NexoItemsLoadedListener;
import com.ordwen.odailyquests.events.listeners.integrations.npcs.CitizensHook;
import com.ordwen.odailyquests.events.listeners.integrations.npcs.FancyNpcsHook;
import com.ordwen.odailyquests.events.listeners.integrations.oraxen.OraxenItemsLoadedListener;
import com.ordwen.odailyquests.events.listeners.inventory.InventoryClickListener;
import com.ordwen.odailyquests.events.listeners.inventory.InventoryCloseListener;
import com.ordwen.odailyquests.events.listeners.item.BlockBreakListener;
import com.ordwen.odailyquests.events.listeners.item.BlockDropItemListener;
import com.ordwen.odailyquests.events.listeners.item.BlockPlaceListener;
import com.ordwen.odailyquests.events.listeners.item.CraftItemListener;
import com.ordwen.odailyquests.events.listeners.item.EnchantItemListener;
import com.ordwen.odailyquests.events.listeners.item.FurnaceExtractListener;
import com.ordwen.odailyquests.events.listeners.item.PickupItemListener;
import com.ordwen.odailyquests.events.listeners.item.PlayerDropItemListener;
import com.ordwen.odailyquests.events.listeners.item.PlayerFishListener;
import com.ordwen.odailyquests.events.listeners.item.PlayerHarvestBlockListener;
import com.ordwen.odailyquests.events.listeners.item.PlayerItemConsumeListener;
import com.ordwen.odailyquests.events.listeners.item.ProjectileLaunchListener;
import com.ordwen.odailyquests.events.listeners.item.SmithItemListener;
import com.ordwen.odailyquests.events.listeners.item.StructureGrowListener;
import com.ordwen.odailyquests.events.listeners.item.custom.DropQueuePushListener;
import com.ordwen.odailyquests.events.listeners.vote.VotifierListener;
import com.ordwen.odailyquests.tools.PluginUtils;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class EventsManager {
    private final ODailyQuests oDailyQuests;

    public EventsManager(ODailyQuests oDailyQuests) {
        this.oDailyQuests = oDailyQuests;
    }

    public void registerListeners() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new EntityBreedListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new EntityTameListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new ShearEntityListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new EntityDeathListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new SpawnerSpawnListener(), (Plugin)this.oDailyQuests);
        if (PluginUtils.isPluginEnabled("EliteMobs")) {
            pluginManager.registerEvents((Listener)new EliteMobDeathListener(), (Plugin)this.oDailyQuests);
        }
        if (PluginUtils.isPluginEnabled("MythicMobs")) {
            pluginManager.registerEvents((Listener)new MythicMobDeathListener(), (Plugin)this.oDailyQuests);
        }
        if (PluginUtils.isPluginEnabled("WildStacker")) {
            pluginManager.registerEvents((Listener)new WildStackerListener(), (Plugin)this.oDailyQuests);
        }
        if (PluginUtils.isPluginEnabled("RoseStacker")) {
            pluginManager.registerEvents((Listener)new RoseStackerListener(), (Plugin)this.oDailyQuests);
        }
        pluginManager.registerEvents((Listener)new BucketFillListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new PlayerExpChangeListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new PlayerLevelChangeListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new PlayerInteractListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new PlayerInteractEntityListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new PlayerDeathListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new PlayerRespawnListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new BlockBreakListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new BlockPlaceListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new CraftItemListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new SmithItemListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new EnchantItemListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new FurnaceExtractListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new PickupItemListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new PlayerFishListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new PlayerItemConsumeListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new ProjectileLaunchListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new InventoryClickListener(this.oDailyQuests.getInterfacesManager().getPlayerQuestsInterface()), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new BlockDropItemListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new PlayerHarvestBlockListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new PlayerDropItemListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new StructureGrowListener(), (Plugin)this.oDailyQuests);
        pluginManager.registerEvents((Listener)new InventoryCloseListener(), (Plugin)this.oDailyQuests);
        if (ItemsAdderEnabled.isEnabled() || OraxenEnabled.isEnabled() || NexoEnabled.isEnabled() || CustomFurnaceResults.isEnabled()) {
            pluginManager.registerEvents((Listener)new CustomFurnaceExtractListener(), (Plugin)this.oDailyQuests);
        }
        if (ItemsAdderEnabled.isEnabled()) {
            pluginManager.registerEvents((Listener)new ItemsAdderLoadDataListener(this.oDailyQuests), (Plugin)this.oDailyQuests);
            pluginManager.registerEvents((Listener)new CustomBlockBreakListener(), (Plugin)this.oDailyQuests);
        }
        if (OraxenEnabled.isEnabled()) {
            pluginManager.registerEvents((Listener)new OraxenItemsLoadedListener(this.oDailyQuests), (Plugin)this.oDailyQuests);
        }
        if (NexoEnabled.isEnabled()) {
            pluginManager.registerEvents((Listener)new NexoItemsLoadedListener(this.oDailyQuests), (Plugin)this.oDailyQuests);
        }
        if (PluginUtils.isPluginEnabled("CustomCrops")) {
            pluginManager.registerEvents((Listener)new CropBreakListener(), (Plugin)this.oDailyQuests);
        }
        if (PluginUtils.isPluginEnabled("CustomFishing")) {
            pluginManager.registerEvents((Listener)new FishingLootSpawnListener(), (Plugin)this.oDailyQuests);
        }
        if (PluginUtils.isPluginEnabled("Votifier")) {
            pluginManager.registerEvents((Listener)new VotifierListener(), (Plugin)this.oDailyQuests);
        }
        if (PluginUtils.isPluginEnabled("ExcellentCrates")) {
            pluginManager.registerEvents((Listener)new CrateOpenListener(), (Plugin)this.oDailyQuests);
        }
        if (PluginUtils.isPluginEnabled("Citizens")) {
            pluginManager.registerEvents((Listener)new CitizensHook(this.oDailyQuests.getInterfacesManager()), (Plugin)this.oDailyQuests);
        }
        if (PluginUtils.isPluginEnabled("FancyNpcs")) {
            pluginManager.registerEvents((Listener)new FancyNpcsHook(this.oDailyQuests.getInterfacesManager()), (Plugin)this.oDailyQuests);
        }
        if (PluginUtils.isPluginEnabled("eco")) {
            pluginManager.registerEvents((Listener)new DropQueuePushListener(), (Plugin)this.oDailyQuests);
        }
    }
}

