/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.events.listeners.entity;

import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.configuration.integrations.RoseStackerEnabled;
import com.ordwen.odailyquests.configuration.integrations.WildStackerEnabled;
import com.ordwen.odailyquests.enums.QuestsPermissions;
import com.ordwen.odailyquests.events.antiglitch.EntitySource;
import com.ordwen.odailyquests.quests.player.progression.PlayerProgressor;
import com.ordwen.odailyquests.tools.PluginUtils;
import dev.rosewood.rosestacker.api.RoseStackerAPI;
import dev.rosewood.rosestacker.stack.StackedEntity;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;

public class EntityDeathListener
extends PlayerProgressor
implements Listener {
    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityDeathEvent(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Player killer = entity.getKiller();
        if (killer == null) {
            return;
        }
        if (this.isExcludedByMythicMobs(entity)) {
            return;
        }
        if (this.isSpawnerKillWithoutBypass(entity, killer)) {
            return;
        }
        if (this.isHandledByWildOrRoseStacker(event, entity)) {
            return;
        }
        Debugger.write("EntityDeathListener: onEntityDeathEvent summoned by " + killer.getName() + " for " + String.valueOf(entity.getType()) + ".");
        this.setPlayerQuestProgression((Event)event, killer, 1, "KILL");
    }

    private boolean isExcludedByMythicMobs(LivingEntity entity) {
        if (!PluginUtils.isPluginEnabled("MythicMobs")) {
            return false;
        }
        Optional opt = MythicBukkit.inst().getMobManager().getActiveMob(entity.getUniqueId());
        if (opt.isEmpty()) {
            Debugger.write("EntityDeathListener: Mob has no active mob.");
            return false;
        }
        Debugger.write("EntityDeathListener: Entity is a MythicMob, checking if it should be excluded.");
        ActiveMob mythicMob = (ActiveMob)opt.get();
        String internalName = mythicMob.getType().getInternalName();
        String upper = internalName.toUpperCase();
        EntityType mapped = null;
        try {
            mapped = EntityType.valueOf((String)upper);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (mapped == null) {
            Debugger.write("EntityDeathListener: Entity is a custom MythicMob (" + internalName + "), cancelling progression.");
            return true;
        }
        if (mapped != entity.getType()) {
            Debugger.write("EntityDeathListener: InternalName maps to " + String.valueOf(mapped) + " but entity is " + String.valueOf(entity.getType()) + ", cancelling progression.");
            return true;
        }
        Debugger.write("EntityDeathListener: MythicMob matches vanilla type " + String.valueOf(mapped) + ", progression allowed.");
        return false;
    }

    private boolean isSpawnerKillWithoutBypass(LivingEntity entity, Player killer) {
        boolean fromSpawner = EntitySource.isEntityFromSpawner((Entity)entity);
        boolean hasBypass = killer.hasPermission(QuestsPermissions.QUESTS_PLAYER_BYPASS_SPAWNER.get());
        if (fromSpawner && !hasBypass) {
            Debugger.write("EntityDeathListener: Entity is from spawner, cancelling progression.");
            return true;
        }
        return false;
    }

    private boolean isHandledByWildOrRoseStacker(EntityDeathEvent event, LivingEntity entity) {
        if (WildStackerEnabled.isEnabled()) {
            Debugger.write("EntityDeathListener: Entity is from WildStacker, must be handled by WildStacker.");
            return true;
        }
        if (RoseStackerEnabled.isEnabled()) {
            Debugger.write("EntityDeathListener: RoseStacker enabled, checking if it is stacked.");
            StackedEntity stacked = RoseStackerAPI.getInstance().getStackedEntity(entity);
            if (stacked != null && stacked.areMultipleEntitiesDying(event)) {
                Debugger.write("EntityDeathListener: Entity is stacked and several are dying, must be handled by RoseStacker.");
                return true;
            }
        }
        return false;
    }
}

