/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.events.listeners.entity.custom.mobs;

import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.configuration.integrations.SharedMobs;
import com.ordwen.odailyquests.quests.player.progression.PlayerProgressor;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.bukkit.events.MythicMobDeathEvent;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class MythicMobDeathListener
extends PlayerProgressor
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onMythicMobsDeathEvent(MythicMobDeathEvent event) {
        ActiveMob activeMob = event.getMob();
        Debugger.write("MythicMobDeathEvent triggered for mob: " + activeMob.getDisplayName());
        if (SharedMobs.isEnabled()) {
            Debugger.write("SharedMobs is enabled, processing threat table for mob: " + activeMob.getDisplayName());
            ActiveMob.ThreatTable threatTable = activeMob.getThreatTable();
            if (threatTable == null || threatTable.getAllThreatTargets().isEmpty()) {
                Debugger.write("Threat table is null or empty for mob: " + activeMob.getDisplayName() + ", falling back to classic progression.");
                LivingEntity livingEntity = event.getKiller();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    this.setPlayerQuestProgression((Event)event, player, 1, "MYTHIC_MOBS");
                }
                return;
            }
            Set targets = threatTable.getAllThreatTargets();
            for (AbstractEntity target : targets) {
                Entity entity = target.getBukkitEntity();
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                this.setPlayerQuestProgression((Event)event, player, 1, "MYTHIC_MOBS");
            }
            return;
        }
        LivingEntity livingEntity = event.getKiller();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.setPlayerQuestProgression((Event)event, player, 1, "MYTHIC_MOBS");
        }
    }
}

