/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.events.listeners.inventory;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.commands.interfaces.playerinterface.PlayerQuestsInterface;
import com.ordwen.odailyquests.configuration.essentials.CustomFurnaceResults;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.events.customs.CustomFurnaceExtractEvent;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import com.ordwen.odailyquests.quests.player.progression.clickable.ClickableChecker;
import com.ordwen.odailyquests.quests.player.progression.clickable.QuestContext;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.MerchantRecipe;

public class InventoryClickListener
extends ClickableChecker
implements Listener {
    private final PlayerQuestsInterface playerQuestsInterface;

    public InventoryClickListener(PlayerQuestsInterface playerQuestsInterface) {
        this.playerQuestsInterface = playerQuestsInterface;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClickEvent(InventoryClickEvent event) {
        ItemStack clickedItem;
        if (event.getClickedInventory() == null) {
            return;
        }
        InventoryAction action = event.getAction();
        if (action == InventoryAction.NOTHING) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!QuestsManager.getActiveQuests().containsKey(player.getName())) {
            return;
        }
        boolean isPlayerInterface = false;
        String inventoryName = event.getView().getTitle();
        if (inventoryName.startsWith(this.playerQuestsInterface.getInterfaceName(player))) {
            isPlayerInterface = true;
            event.setCancelled(true);
        }
        Debugger.write("Clicked item: " + ((clickedItem = event.getCurrentItem()) != null ? clickedItem.getType().name() : "null"));
        Debugger.write("Clicked item amount: " + String.valueOf(clickedItem != null ? Integer.valueOf(clickedItem.getAmount()) : "null"));
        Debugger.write("Cursor item: " + (event.getCursor() != null ? event.getCursor().getType().name() : "null"));
        Debugger.write("Cursor item amount: " + String.valueOf(event.getCursor() != null ? Integer.valueOf(event.getCursor().getAmount()) : "null"));
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (this.handleCustomFurnaceResult(event, action, clickedItem, player)) {
            return;
        }
        QuestContext.Builder contextBuilder = new QuestContext.Builder(player).clickedItem(clickedItem);
        if (this.handleVillagerTrading(event, clickedItem, contextBuilder)) {
            return;
        }
        if (isPlayerInterface) {
            if (this.handlePlayerInterfaceClick(event, clickedItem, player)) {
                return;
            }
            this.processQuestCompletion(contextBuilder.build());
        }
    }

    private boolean handlePlayerInterfaceClick(InventoryClickEvent event, ItemStack clickedItem, Player player) {
        if (event.getAction() == InventoryAction.HOTBAR_SWAP) {
            return true;
        }
        if (this.playerQuestsInterface.isFillItem(clickedItem)) {
            return true;
        }
        int slot = event.getRawSlot();
        if (this.handlePlayerCommandItem(player, slot)) {
            return true;
        }
        if (this.handleConsoleCommandItem(player, slot)) {
            return true;
        }
        return this.handleCloseItem(clickedItem, player);
    }

    private boolean handleVillagerTrading(InventoryClickEvent event, ItemStack clickedItem, QuestContext.Builder contextBuilder) {
        if (event.getInventory().getType() == InventoryType.MERCHANT && event.getSlotType() == InventoryType.SlotType.RESULT) {
            Debugger.write("Detected villager trade action");
            MerchantInventory merchantInventory = (MerchantInventory)event.getClickedInventory();
            if (merchantInventory == null) {
                Debugger.write("Merchant Inventory is null");
                return false;
            }
            InventoryHolder inventoryHolder = event.getClickedInventory().getHolder();
            if (inventoryHolder instanceof Villager) {
                Villager villager = (Villager)inventoryHolder;
                int amount = this.getTradeAmount(event, clickedItem, merchantInventory);
                Debugger.write("Trade amount is " + amount);
                if (amount == 0) {
                    return true;
                }
                MerchantRecipe selectedRecipe = merchantInventory.getSelectedRecipe();
                if (selectedRecipe != null) {
                    contextBuilder.villagerTrade(villager, selectedRecipe, amount);
                    this.processQuestCompletion(contextBuilder.build());
                }
            }
            return true;
        }
        return false;
    }

    private boolean handleCustomFurnaceResult(InventoryClickEvent event, InventoryAction action, ItemStack clickedItem, Player player) {
        InventoryType inventoryType;
        if (CustomFurnaceResults.isEnabled() && ((inventoryType = event.getInventory().getType()) == InventoryType.FURNACE || inventoryType == InventoryType.BLAST_FURNACE || inventoryType == InventoryType.SMOKER)) {
            if (event.getSlotType() != InventoryType.SlotType.RESULT) {
                return true;
            }
            int amount = switch (action) {
                case InventoryAction.PICKUP_HALF -> (int)Math.ceil((double)clickedItem.getAmount() / 2.0);
                case InventoryAction.PICKUP_ONE, InventoryAction.DROP_ONE_SLOT -> 1;
                case InventoryAction.MOVE_TO_OTHER_INVENTORY -> {
                    int max = clickedItem.getAmount();
                    yield Math.min(max, this.fits(clickedItem, player.getInventory().getStorageContents()));
                }
                default -> clickedItem.getAmount();
            };
            if (amount == 0) {
                return true;
            }
            CustomFurnaceExtractEvent customFurnaceExtractEvent = new CustomFurnaceExtractEvent(player, clickedItem, amount);
            Bukkit.getServer().getPluginManager().callEvent((Event)customFurnaceExtractEvent);
            return true;
        }
        return false;
    }

    private int getTradeAmount(InventoryClickEvent event, ItemStack clickedItem, MerchantInventory merchantInventory) {
        int perTradeResult = clickedItem.getAmount();
        Debugger.write("Per trade result amount is " + perTradeResult);
        if (perTradeResult <= 0) {
            return 0;
        }
        ClickType click = event.getClick();
        Debugger.write("Click type is " + click.name());
        InventoryAction action = event.getAction();
        Debugger.write("Inventory action is " + action.name());
        boolean bulk = click == ClickType.SHIFT_LEFT || click == ClickType.SHIFT_RIGHT || action == InventoryAction.MOVE_TO_OTHER_INVENTORY || action == InventoryAction.HOTBAR_MOVE_AND_READD;
        Debugger.write("Bulk action is " + bulk);
        if (!bulk) {
            return perTradeResult;
        }
        int tradesPossible = this.getMaxTradesPossible(merchantInventory);
        Debugger.write("Max trades possible is " + tradesPossible);
        if (tradesPossible <= 0) {
            return 0;
        }
        int capacityItems = this.fits(clickedItem, event.getView().getBottomInventory().getStorageContents());
        Debugger.write("Capacity in player inventory is " + capacityItems);
        if (capacityItems <= 0) {
            return 0;
        }
        int itemsIfUnlimitedSpace = tradesPossible * perTradeResult;
        Debugger.write("Items if unlimited space is " + itemsIfUnlimitedSpace);
        return Math.min(itemsIfUnlimitedSpace, capacityItems);
    }

    private int getMaxTradesPossible(MerchantInventory inv) {
        MerchantRecipe recipe = inv.getSelectedRecipe();
        if (recipe == null) {
            return 0;
        }
        int usesLeft = recipe.getMaxUses() - recipe.getUses();
        if (usesLeft <= 0) {
            return 0;
        }
        List reqs = recipe.getIngredients();
        ItemStack req1 = !reqs.isEmpty() ? (ItemStack)reqs.get(0) : null;
        ItemStack req2 = reqs.size() >= 2 ? (ItemStack)reqs.get(1) : null;
        ItemStack in1 = inv.getItem(0);
        ItemStack in2 = inv.getItem(1);
        int byIng1 = this.getIngredientCount(req1, in1, in2);
        int byIng2 = this.getIngredientCount(req2, in1, in2);
        int byIngredients = byIng1 == Integer.MAX_VALUE && byIng2 == Integer.MAX_VALUE ? usesLeft : Math.min(byIng1, byIng2);
        return Math.min(byIngredients, usesLeft);
    }

    private int getIngredientCount(ItemStack required, ItemStack in1, ItemStack in2) {
        if (required == null || required.getType() == Material.AIR) {
            return Integer.MAX_VALUE;
        }
        int have = 0;
        if (in1 != null && in1.isSimilar(required)) {
            have = in1.getAmount();
        } else if (in2 != null && in2.isSimilar(required)) {
            have = in2.getAmount();
        }
        if (have <= 0) {
            return 0;
        }
        return have / Math.max(1, required.getAmount());
    }

    private boolean handleCloseItem(ItemStack clickedItem, Player player) {
        if (this.playerQuestsInterface.isCloseItem(clickedItem)) {
            player.closeInventory();
            return true;
        }
        return false;
    }

    private boolean handlePlayerCommandItem(Player player, int slot) {
        if (this.playerQuestsInterface.isPlayerCommandItem(slot)) {
            for (String cmd : this.playerQuestsInterface.getPlayerCommands(slot)) {
                Bukkit.getServer().dispatchCommand((CommandSender)player, cmd);
            }
            return true;
        }
        return false;
    }

    private boolean handleConsoleCommandItem(Player player, int slot) {
        if (this.playerQuestsInterface.isConsoleCommandItem(slot)) {
            for (String cmd : this.playerQuestsInterface.getConsoleCommands(slot)) {
                ODailyQuests.morePaperLib.scheduling().globalRegionalScheduler().run(() -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), cmd.replace("%player%", player.getName())));
            }
            return true;
        }
        return false;
    }
}

