/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.events.listeners.item;

import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.quests.player.progression.PlayerProgressor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class CraftItemListener
extends PlayerProgressor
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCraftItemEvent(CraftItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ItemStack current = event.getCurrentItem();
        if (current == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack result = this.resolveResultItem(event, current);
        if (result == null) {
            return;
        }
        int amount = this.computeRecipeAmount(event, player, result);
        if (amount <= 0) {
            return;
        }
        result.setAmount(amount);
        Debugger.write("CraftItemListener: onCraftItemEvent summoned by " + player.getName() + " for " + String.valueOf(result.getType()) + " x" + result.getAmount() + ".");
        this.setPlayerQuestProgression((Event)event, player, result.getAmount(), "CRAFT");
    }

    private ItemStack resolveResultItem(CraftItemEvent event, ItemStack fallback) {
        Recipe recipe = event.getRecipe();
        if (recipe instanceof ComplexRecipe) {
            ComplexRecipe complex = (ComplexRecipe)recipe;
            Material mat = Material.getMaterial((String)complex.getKey().getKey().toUpperCase());
            return mat == null ? null : new ItemStack(mat);
        }
        return fallback.clone();
    }

    private int computeRecipeAmount(CraftItemEvent event, Player player, ItemStack sample) {
        ClickType click = event.getClick();
        int baseAmount = sample.getAmount();
        return switch (click) {
            case ClickType.NUMBER_KEY -> this.handleNumberKey(event, baseAmount);
            case ClickType.DROP, ClickType.CONTROL_DROP -> this.handleDrop(event, baseAmount);
            case ClickType.LEFT, ClickType.RIGHT -> this.handleCursorClick(event, sample, baseAmount, click == ClickType.RIGHT);
            case ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT -> this.handleShiftClick(event, player, sample, baseAmount);
            case ClickType.SWAP_OFFHAND -> this.handleSwapOffhand(player);
            default -> 0;
        };
    }

    private int handleNumberKey(CraftItemEvent event, int baseAmount) {
        boolean slotBusy = event.getWhoClicked().getInventory().getItem(event.getHotbarButton()) != null;
        return slotBusy ? 0 : baseAmount;
    }

    private int handleDrop(CraftItemEvent event, int baseAmount) {
        return this.isCursorEmpty(event.getCursor()) ? baseAmount : 0;
    }

    private int handleCursorClick(CraftItemEvent event, ItemStack sample, int baseAmount, boolean rightClick) {
        ItemStack cursor = event.getCursor();
        if (this.isCursorEmpty(cursor)) {
            return rightClick ? Math.min(1, baseAmount) : baseAmount;
        }
        if (!cursor.isSimilar(sample)) {
            return 0;
        }
        int max = Math.min(cursor.getMaxStackSize(), sample.getMaxStackSize());
        int space = max - cursor.getAmount();
        if (space <= 0) {
            return 0;
        }
        return rightClick ? 1 : Math.min(baseAmount, space);
    }

    private int handleShiftClick(CraftItemEvent event, Player player, ItemStack sample, int baseAmount) {
        if (baseAmount <= 0) {
            return 0;
        }
        int maxCraftable = this.getMaxCraftAmount(event.getInventory());
        int capacity = this.fits(sample, player.getInventory().getStorageContents());
        if (capacity < maxCraftable) {
            maxCraftable = (capacity + baseAmount - 1) / baseAmount * baseAmount;
        }
        return maxCraftable;
    }

    private int handleSwapOffhand(Player player) {
        boolean offhandBusy = player.getInventory().getItemInOffHand().getType() != Material.AIR;
        return offhandBusy ? 0 : 1;
    }

    private boolean isCursorEmpty(ItemStack cursor) {
        return cursor == null || cursor.getType() == Material.AIR;
    }

    private int getMaxCraftAmount(CraftingInventory inv) {
        if (inv.getResult() == null) {
            return 0;
        }
        int resultCount = inv.getResult().getAmount();
        int materialCount = Integer.MAX_VALUE;
        for (ItemStack is : inv.getMatrix()) {
            if (is == null || is.getAmount() >= materialCount) continue;
            materialCount = is.getAmount();
        }
        return resultCount * materialCount;
    }
}

