/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.events.listeners.item.custom;

import com.ordwen.odailyquests.configuration.essentials.Antiglitch;
import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.quests.player.progression.PlayerProgressor;
import com.ordwen.odailyquests.quests.types.item.FarmingQuest;
import com.willfp.eco.core.events.DropQueuePushEvent;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class DropQueuePushListener
extends PlayerProgressor
implements Listener {
    private static BlockState currentState;

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDropQueuePush(DropQueuePushEvent event) {
        Debugger.write("DropQueuePushListener: onDropQueuePush event summoned.");
        if (event.isCancelled()) {
            Debugger.write("DropQueuePushListener: onDropQueuePush event is cancelled.");
            return;
        }
        Player player = event.getPlayer();
        BlockData data = currentState.getBlockData();
        Material dataMaterial = data.getMaterial();
        Debugger.write("DropQueuePushListener: onDropQueuePush event triggered by player: " + player.getName() + ".");
        Collection drops = event.getItems();
        if (drops.isEmpty()) {
            Debugger.write("DropQueuePushListener: onDropQueuePush event no drops.");
            return;
        }
        if (this.isAgeableAndFullyGrown(event, data, dataMaterial, drops)) {
            return;
        }
        if (this.isPlayerPlacedBlock(currentState.getBlock(), dataMaterial)) {
            return;
        }
        this.handleDrops(event, drops);
        this.handleStoreBrokenBlocks(drops, player, dataMaterial);
    }

    private boolean isAgeableAndFullyGrown(DropQueuePushEvent event, BlockData data, Material dataMaterial, Collection<? extends ItemStack> drops) {
        if (data instanceof Ageable) {
            Ageable ageable = (Ageable)data;
            Debugger.write("DropQueuePushListener: onBlockDropItemEvent ageable block: " + String.valueOf(dataMaterial) + ".");
            if (ageable.getAge() == ageable.getMaximumAge()) {
                Debugger.write("DropQueuePushListener: onBlockDropItemEvent ageable block is mature.");
                this.handleDrops(event, drops);
                return true;
            }
            Debugger.write("DropQueuePushListener: onBlockDropItemEvent ageable block is not mature.");
        }
        return false;
    }

    private void handleDrops(DropQueuePushEvent event, Collection<? extends ItemStack> drops) {
        Debugger.write("DropQueuePushListener: handleDrops summoned.");
        for (ItemStack itemStack : drops) {
            Material droppedMaterial = itemStack.getType();
            Debugger.write("DropQueuePushListener: handling drop: " + String.valueOf(droppedMaterial) + ".");
            FarmingQuest.setCurrent(new ItemStack(droppedMaterial));
            this.setPlayerQuestProgression((Event)event, event.getPlayer(), itemStack.getAmount(), "FARMING");
        }
    }

    private void handleStoreBrokenBlocks(Collection<? extends ItemStack> drops, Player player, Material material) {
        if (material.isBlock() && Antiglitch.isStoreBrokenBlocks()) {
            Debugger.write("DropQueuePushListener: onBlockDropItemEvent storing broken block.");
            this.storeBrokenBlockMetadata(drops, player);
        }
    }

    public static void setCurrentState(BlockState currentState) {
        DropQueuePushListener.currentState = currentState;
    }

    public static BlockState getCurrentState() {
        return currentState;
    }
}

