/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.externs;

import com.ordwen.odailyquests.ODailyQuests;
import com.ordwen.odailyquests.externs.hooks.Protection;
import com.ordwen.odailyquests.externs.hooks.eco.VaultHook;
import com.ordwen.odailyquests.externs.hooks.items.KGeneratorsHook;
import com.ordwen.odailyquests.externs.hooks.placeholders.PAPIExpansion;
import com.ordwen.odailyquests.externs.hooks.points.PlayerPointsHook;
import com.ordwen.odailyquests.externs.hooks.points.TokenManagerHook;
import com.ordwen.odailyquests.tools.PluginUtils;

public class IntegrationsManager {
    private final ODailyQuests oDailyQuests;

    public IntegrationsManager(ODailyQuests oDailyQuests) {
        this.oDailyQuests = oDailyQuests;
    }

    public void loadAllDependencies() {
        this.loadVault();
        this.loadPointsPlugin();
        this.loadPAPI();
        this.loadKGenerators();
        new Protection().load();
    }

    private void loadPointsPlugin() {
        TokenManagerHook.setupTokenManager();
        PlayerPointsHook.setupPlayerPointsAPI();
    }

    private void loadVault() {
        VaultHook.setupEconomy();
    }

    private void loadPAPI() {
        if (PluginUtils.isPluginEnabled("PlaceholderAPI")) {
            new PAPIExpansion(this.oDailyQuests.getInterfacesManager().getPlayerQuestsInterface()).register();
        }
    }

    private void loadKGenerators() {
        KGeneratorsHook.setupKGeneratorsAPI();
    }
}

