/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.externs.hooks;

import com.ordwen.odailyquests.configuration.essentials.Debugger;
import com.ordwen.odailyquests.tools.PluginLogger;
import com.ordwen.odailyquests.tools.PluginUtils;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.internal.platform.WorldGuardPlatform;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class Protection {
    private static boolean isTownyEnabled = false;
    private static boolean isWorldguardEnabled = false;
    private static WorldGuardPlatform wgPlatform = null;

    public void load() {
        if (PluginUtils.isPluginEnabled("Towny")) {
            Protection.setTownyEnabled();
            PluginLogger.info("Towny detected, hook enabled.");
        }
        if (PluginUtils.isPluginEnabled("WorldGuard")) {
            Protection.setWorldGuardPlatform(WorldGuard.getInstance().getPlatform());
            Protection.setWorldGuardEnabled();
            PluginLogger.info("WorldGuard detected, hook enabled.");
        }
    }

    public static boolean isTownyEnabled() {
        return isTownyEnabled;
    }

    public static void setTownyEnabled() {
        isTownyEnabled = true;
    }

    private static void setWorldGuardPlatform(WorldGuardPlatform platform) {
        wgPlatform = platform;
    }

    public static boolean isWorldGuardEnabled() {
        return isWorldguardEnabled;
    }

    public static void setWorldGuardEnabled() {
        isWorldguardEnabled = true;
    }

    public static boolean canBuild(Player player, Block block, String flag) {
        Debugger.write("Protection: canBuild summoned.");
        if (!Protection.isTownyEnabled() && !Protection.isWorldGuardEnabled()) {
            Debugger.write("Protection: canBuild no hooks enabled.");
            return true;
        }
        return Protection.checkTowny(player, block) && Protection.checkWg(player, block, flag);
    }

    private static boolean checkTowny(Player player, Block block) {
        if (!Protection.isTownyEnabled()) {
            return true;
        }
        Debugger.write("Protection: checkTowny summoned.");
        Location location = block.getLocation();
        boolean canBuild = PlayerCacheUtil.getCachePermission((Player)player, (Location)location, (Material)block.getType(), (TownyPermission.ActionType)TownyPermission.ActionType.BUILD);
        Debugger.write("Protection: checkTowny result: " + canBuild);
        return canBuild;
    }

    public static boolean checkWg(Player player, Block block, String flag) {
        if (!Protection.isWorldGuardEnabled()) {
            return true;
        }
        Debugger.write("Protection: checkWg summoned.");
        Location location = block.getLocation();
        if (location.getWorld() == null) {
            return true;
        }
        com.sk89q.worldedit.util.Location adaptedLocation = BukkitAdapter.adapt((Location)location);
        World adaptedWorld = BukkitAdapter.adapt((org.bukkit.World)location.getWorld());
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        if (wgPlatform.getSessionManager().hasBypass(localPlayer, adaptedWorld)) {
            Debugger.write("Protection: checkWg bypassed.");
            return true;
        }
        RegionQuery query = wgPlatform.getRegionContainer().createQuery();
        StateFlag stateFlag = switch (flag) {
            case "BLOCK_BREAK" -> Flags.BLOCK_BREAK;
            case "BLOCK_PLACE" -> Flags.BLOCK_PLACE;
            default -> Flags.BUILD;
        };
        boolean canBuild = query.testBuild(adaptedLocation, localPlayer, new StateFlag[]{stateFlag});
        Debugger.write("Protection: checkWg result: " + canBuild);
        return canBuild;
    }

    public static boolean checkRegion(Player player, List<String> requiredRegions) {
        if (!Protection.isWorldGuardEnabled()) {
            return true;
        }
        Debugger.write("Protection: checkRegion summoned.");
        Location location = player.getLocation();
        if (location.getWorld() == null) {
            return true;
        }
        com.sk89q.worldedit.util.Location adaptedLocation = BukkitAdapter.adapt((Location)location);
        RegionContainer container = wgPlatform.getRegionContainer();
        RegionQuery query = container.createQuery();
        ApplicableRegionSet regions = query.getApplicableRegions(adaptedLocation);
        for (String region : requiredRegions) {
            if (regions.size() == 0) {
                return false;
            }
            if (!regions.getRegions().stream().noneMatch(r -> r.getId().equalsIgnoreCase(region))) continue;
            return false;
        }
        return true;
    }
}

