/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.externs.hooks.placeholders;

import com.ordwen.odailyquests.api.ODailyQuestsAPI;
import com.ordwen.odailyquests.commands.interfaces.playerinterface.PlayerQuestsInterface;
import com.ordwen.odailyquests.configuration.functionalities.progression.ProgressBar;
import com.ordwen.odailyquests.quests.categories.CategoriesLoader;
import com.ordwen.odailyquests.quests.categories.Category;
import com.ordwen.odailyquests.quests.player.PlayerQuests;
import com.ordwen.odailyquests.quests.player.QuestsManager;
import com.ordwen.odailyquests.quests.player.progression.Progression;
import com.ordwen.odailyquests.quests.player.progression.QuestLoaderUtils;
import com.ordwen.odailyquests.quests.types.AbstractQuest;
import com.ordwen.odailyquests.tools.TextFormatter;
import com.ordwen.odailyquests.tools.TimeRemain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PAPIExpansion
extends PlaceholderExpansion {
    private static final String INVALID_INDEX = String.valueOf(ChatColor.RED) + "Invalid index.";
    private final PlayerQuestsInterface playerQuestsInterface;

    public PAPIExpansion(PlayerQuestsInterface playerQuestsInterface) {
        TextFormatter.setPlaceholderAPIEnabled(true);
        this.playerQuestsInterface = playerQuestsInterface;
    }

    @NotNull
    public String getIdentifier() {
        return "odailyquests";
    }

    @NotNull
    public String getAuthor() {
        return "Ordwen";
    }

    @NotNull
    public String getVersion() {
        return "1.0.4";
    }

    public boolean persist() {
        return true;
    }

    @NotNull
    public List<String> getPlaceholders() {
        ArrayList<String> placeholdersList = new ArrayList<String>();
        placeholdersList.add("%odailyquests_total%");
        placeholdersList.add("%odailyquests_achieved%");
        placeholdersList.add("%odailyquests_drawin%");
        placeholdersList.add("%odailyquests_name_");
        placeholdersList.add("%odailyquests_desc_");
        placeholdersList.add("%odailyquests_progress_");
        placeholdersList.add("%odailyquests_progressbar_");
        placeholdersList.add("%odailyquests_iscompleted_");
        placeholdersList.add("%odailyquests_requiredamount_");
        Map<String, Category> categoryMap = CategoriesLoader.getAllCategories();
        for (String categoryKey : categoryMap.keySet()) {
            placeholdersList.add("%odailyquests_" + categoryKey + "_");
            placeholdersList.add("%odailyquests_total_" + categoryKey + "%");
        }
        return placeholdersList;
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (!QuestsManager.getActiveQuests().containsKey(player.getName())) {
            return null;
        }
        if (QuestLoaderUtils.isTimeToRenew((Player)player, QuestsManager.getActiveQuests())) {
            return null;
        }
        PlayerQuests playerQuests = ODailyQuestsAPI.getPlayerQuests(player.getName());
        HashMap<String, Function<String, String>> placeholders = new HashMap<String, Function<String, String>>();
        placeholders.put("total", p -> this.getTotalAchievedQuests((String)p, playerQuests));
        placeholders.put("achieved", p -> String.valueOf(playerQuests.getAchievedQuests()));
        placeholders.put("drawin", p -> TimeRemain.timeRemain(player.getName()));
        placeholders.put("interface", p -> this.getInterfaceMessage((String)p, player, playerQuests));
        placeholders.put("progressbar", p -> this.getProgressBar((String)p, playerQuests));
        placeholders.put("progress", p -> String.valueOf(this.getPlayerQuestProgression((String)p, playerQuests)));
        placeholders.put("name", p -> this.getPlayerQuestName((String)p, playerQuests));
        placeholders.put("desc", p -> this.getPlayerQuestDescription((String)p, playerQuests));
        placeholders.put("iscompleted", p -> this.isPlayerQuestCompleted((String)p, playerQuests));
        placeholders.put("requiredamount", p -> this.getPlayerQuestRequiredAmount((String)p, playerQuests));
        for (Map.Entry entry : placeholders.entrySet()) {
            if (!params.startsWith((String)entry.getKey())) continue;
            return (String)((Function)entry.getValue()).apply(params);
        }
        return this.getQuestNameByCategory(params);
    }

    private String getTotalAchievedQuests(String p, PlayerQuests playerQuests) {
        if (p.equals("total")) {
            return String.valueOf(playerQuests.getTotalAchievedQuests());
        }
        if (p.startsWith("total_")) {
            String categoryName = p.substring("total_".length());
            if (CategoriesLoader.getAllCategories().containsKey(categoryName)) {
                return String.valueOf(playerQuests.getTotalAchievedQuestsByCategory(categoryName));
            }
            return String.valueOf(ChatColor.RED) + "Invalid category.";
        }
        return String.valueOf(ChatColor.RED) + "Invalid placeholder.";
    }

    private String getQuestNameByCategory(String params) {
        Map<String, Category> categoryMap = CategoriesLoader.getAllCategories();
        for (Map.Entry<String, Category> entry : categoryMap.entrySet()) {
            if (!params.startsWith(entry.getKey())) continue;
            return this.getQuestName(params, entry.getValue());
        }
        return null;
    }

    private String getInterfaceMessage(String params, OfflinePlayer player, PlayerQuests playerQuests) {
        if (params.equals("interface_complete_get_type")) {
            return TextFormatter.format((Player)player, this.playerQuestsInterface.getCompleteGetTypeStr());
        }
        if (params.startsWith("interface_status_")) {
            int index;
            String supposedIndex = params.substring("interface_status_".length());
            try {
                index = Integer.parseInt(supposedIndex) - 1;
            }
            catch (Exception e) {
                return INVALID_INDEX;
            }
            return TextFormatter.format((Player)player, this.getQuestStatus(index, playerQuests));
        }
        return String.valueOf(ChatColor.RED) + "Invalid placeholder.";
    }

    private String isPlayerQuestCompleted(String params, PlayerQuests playerQuests) {
        int index;
        try {
            index = Integer.parseInt(params.substring(params.indexOf(95) + 1)) - 1;
        }
        catch (Exception e) {
            return INVALID_INDEX;
        }
        int i = 0;
        for (AbstractQuest quest : playerQuests.getQuests().keySet()) {
            if (i == index) {
                return String.valueOf(playerQuests.getQuests().get(quest).isAchieved());
            }
            ++i;
        }
        return INVALID_INDEX;
    }

    private String getQuestStatus(int index, PlayerQuests playerQuests) {
        int i = 0;
        for (AbstractQuest quest : playerQuests.getQuests().keySet()) {
            if (i == index) {
                Progression progression = playerQuests.getQuests().get(quest);
                return (playerQuests.getQuests().get(quest).isAchieved() ? this.playerQuestsInterface.getAchievedStr() : this.playerQuestsInterface.getProgressStr()).replace("%progress%", String.valueOf(progression.getAdvancement())).replace("%required%", String.valueOf(progression.getRequiredAmount())).replace("%progressBar%", ProgressBar.getProgressBar(progression.getAdvancement(), progression.getRequiredAmount()));
            }
            ++i;
        }
        return INVALID_INDEX;
    }

    private String getPlayerQuestName(String params, PlayerQuests playerQuests) {
        int index;
        try {
            index = Integer.parseInt(params.substring(params.indexOf("_") + 1)) - 1;
        }
        catch (Exception e) {
            return INVALID_INDEX;
        }
        int i = 0;
        for (AbstractQuest quest : playerQuests.getQuests().keySet()) {
            if (i == index) {
                return quest.getQuestName();
            }
            ++i;
        }
        return INVALID_INDEX;
    }

    private String getPlayerQuestRequiredAmount(String params, PlayerQuests playerQuests) {
        int index;
        try {
            index = Integer.parseInt(params.substring(params.indexOf(95) + 1)) - 1;
        }
        catch (Exception e) {
            return INVALID_INDEX;
        }
        int i = 0;
        for (AbstractQuest quest : playerQuests.getQuests().keySet()) {
            if (i == index) {
                Progression progression = playerQuests.getQuests().get(quest);
                return String.valueOf(progression.getRequiredAmount());
            }
            ++i;
        }
        return INVALID_INDEX;
    }

    private String getPlayerQuestDescription(String params, PlayerQuests playerQuests) {
        int line;
        int index;
        try {
            index = Integer.parseInt(params.substring(params.indexOf("_") + 1, params.lastIndexOf("_"))) - 1;
        }
        catch (Exception e) {
            return INVALID_INDEX;
        }
        try {
            line = Integer.parseInt(params.substring(params.lastIndexOf("_") + 1)) - 1;
        }
        catch (Exception e) {
            return String.valueOf(ChatColor.RED) + "Invalid line.";
        }
        int i = 0;
        for (AbstractQuest quest : playerQuests.getQuests().keySet()) {
            if (i == index) {
                if (line <= quest.getQuestDesc().size()) {
                    return quest.getQuestDesc().get(line);
                }
                return String.valueOf(ChatColor.RED) + "Invalid line.";
            }
            ++i;
        }
        return INVALID_INDEX;
    }

    public int getPlayerQuestProgression(String params, PlayerQuests playerQuests) {
        int index;
        try {
            index = Integer.parseInt(params.substring(params.indexOf("_") + 1)) - 1;
        }
        catch (Exception e) {
            return -1;
        }
        int i = 0;
        for (AbstractQuest quest : playerQuests.getQuests().keySet()) {
            if (i == index) {
                return playerQuests.getQuests().get(quest).getAdvancement();
            }
            ++i;
        }
        return -1;
    }

    private String getProgressBar(String params, PlayerQuests playerQuests) {
        int index;
        try {
            index = Integer.parseInt(params.substring(params.indexOf("_") + 1)) - 1;
        }
        catch (Exception e) {
            return INVALID_INDEX;
        }
        int i = 0;
        for (AbstractQuest quest : playerQuests.getQuests().keySet()) {
            if (i == index) {
                Progression progression = playerQuests.getQuests().get(quest);
                return ProgressBar.getProgressBar(progression.getAdvancement(), progression.getRequiredAmount());
            }
            ++i;
        }
        return INVALID_INDEX;
    }

    private String getQuestName(String params, List<AbstractQuest> quests) {
        int index;
        try {
            index = Integer.parseInt(params.substring(params.indexOf("_") + 1)) - 1;
        }
        catch (Exception e) {
            return INVALID_INDEX;
        }
        if (quests.size() - 1 >= index) {
            return quests.get(index).getQuestName();
        }
        return INVALID_INDEX;
    }
}

