/*
 * Decompiled with CFR 0.152.
 */
package com.ordwen.odailyquests.nms;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.ordwen.odailyquests.tools.PluginLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class NMSHandler {
    private static final UUID DUMMY_UUID = UUID.randomUUID();
    private static NMSHandler instance;
    private final String version = Bukkit.getBukkitVersion().split("-")[0];

    private NMSHandler() {
    }

    public static NMSHandler getInstance() {
        if (instance == null) {
            instance = new NMSHandler();
        }
        return instance;
    }

    public boolean isVersionAtLeast(String versionPrefix) {
        return this.version.compareTo(versionPrefix) >= 0;
    }

    public static SkullMeta applySkullTexture(SkullMeta skullMeta, String texture) {
        if (NMSHandler.getInstance().isVersionAtLeast("1.18.1")) {
            return NMSHandler.applyTextureModern(skullMeta, texture);
        }
        return NMSHandler.applyTextureLegacy(skullMeta, texture);
    }

    private static SkullMeta applyTextureModern(SkullMeta skullMeta, String texture) {
        URL url;
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)DUMMY_UUID);
        PlayerTextures textures = profile.getTextures();
        try {
            url = new URL("http://textures.minecraft.net/texture/" + texture);
        }
        catch (MalformedURLException e) {
            PluginLogger.error("Failed to apply skull texture: " + e.getMessage());
            return skullMeta;
        }
        textures.setSkin(url);
        profile.setTextures(textures);
        skullMeta.setOwnerProfile(profile);
        return skullMeta;
    }

    private static SkullMeta applyTextureLegacy(SkullMeta skullMeta, String texture) {
        GameProfile profile = new GameProfile(DUMMY_UUID, "odq_skull");
        String toEncode = "{textures:{SKIN:{url:\"https://textures.minecraft.net/texture/" + texture + "\"}}}";
        byte[] data = Base64.getEncoder().encodeToString(toEncode.getBytes()).getBytes();
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(data)));
        try {
            Method setProfileMethod = skullMeta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
            setProfileMethod.setAccessible(true);
            setProfileMethod.invoke((Object)skullMeta, profile);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            PluginLogger.error("Failed to apply skull texture: " + e.getMessage());
        }
        return skullMeta;
    }

    public String getVersion() {
        return this.version;
    }
}

